<?php if (\Illuminate\Support\Facades\Blade::check('can', ['admin.setting.notification.global.email', 'admin.setting.notification.email', 'admin.setting.notification.sms', 'admin.setting.notification.push', 'admin.setting.notification.templates'])): ?>
    <ul class="nav nav-tabs mb-4 topTap breadcrumb-nav" role="tablist">
        <button class="breadcrumb-nav-close"><i class="las la-times"></i></button>

        <?php
            $globalTemplateRoutes = ['admin.setting.notification.global.email', 'admin.setting.notification.global.sms', 'admin.setting.notification.global.push'];
        ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('can', $globalTemplateRoutes)): ?>
            <li class="nav-item <?php echo e(menuActive($globalTemplateRoutes)); ?>" role="presentation">

                <?php $__currentLoopData = $globalTemplateRoutes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (\Illuminate\Support\Facades\Blade::check('can', $route)): ?>
                        <a href="<?php echo e(route($route)); ?>" class="nav-link text-dark" type="button">
                            <i class="las la-globe"></i> <?php echo app('translator')->get('Global Template'); ?>
                        </a>
                        <?php break; ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </li>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.setting.notification.email')): ?>
            <li class="nav-item <?php echo e(menuActive('admin.setting.notification.email')); ?>" role="presentation">
                <a href="<?php echo e(route('admin.setting.notification.email')); ?>" class="nav-link text-dark" type="button">
                    <i class="las la-envelope"></i> <?php echo app('translator')->get('Email Setting'); ?>
                </a>
            </li>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.setting.notification.sms')): ?>
            <li class="nav-item <?php echo e(menuActive('admin.setting.notification.sms')); ?>" role="presentation">
                <a href="<?php echo e(route('admin.setting.notification.sms')); ?>" class="nav-link text-dark" type="button">
                    <i class="las la-sms"></i> <?php echo app('translator')->get('SMS Setting'); ?>
                </a>
            </li>
        <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.setting.notification.push')): ?>
            <li class="nav-item <?php echo e(menuActive('admin.setting.notification.push')); ?>" role="presentation">
                <a href="<?php echo e(route('admin.setting.notification.push')); ?>" class="nav-link text-dark" type="button">
                    <i class="las la-bell"></i> <?php echo app('translator')->get('Push Notification Setting'); ?>
                </a>
            </li>
        <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.setting.notification.templates')): ?>
            <li class="nav-item <?php echo e(menuActive(['admin.setting.notification.templates', 'admin.setting.notification.template.edit'])); ?>" role="presentation">
                <a href="<?php echo e(route('admin.setting.notification.templates')); ?>" class="nav-link text-dark" type="button">
                    <i class="las la-list"></i> <?php echo app('translator')->get('Notification Templates'); ?>
                </a>
            </li>
        <?php endif; ?>
    </ul>
<?php endif; ?>
<?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/notification/top_bar.blade.php ENDPATH**/ ?>