<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-xl-5 col-md-6 mb-30">
            <div class="card overflow-hidden">
                <div class="card-header">
                    <h5 class="card-title"><?php echo app('translator')->get('Sender\'s Information'); ?></h5>
                </div>
                <div class="card-body p-0">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item px-3">
                            <span class="fw-bold"><?php echo app('translator')->get('Username'); ?></span>
                            <span class="text--primary fw-bold">

                                <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.users.detail')): ?>
                                @<a class="text--primary" href="<?php echo e(route('admin.users.detail', $transfer->user_id)); ?>" target="_blank"><?php echo e($transfer->user->username); ?></a>
                                <?php else: ?>
                                    <?php echo e($transfer->user->username); ?>

                                <?php endif; ?>
                            </span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"> <?php echo app('translator')->get('Account Number'); ?></span>
                            <span><?php echo e(__(@$transfer->user->account_number)); ?></span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"> <?php echo app('translator')->get('Account Name'); ?></span>
                            <span><?php echo e(__(@$transfer->user->fullname)); ?></span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"><?php echo app('translator')->get('Amount'); ?></span>
                            <span class="fw-bold"><?php echo e(showAmount($transfer->amount)); ?></span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"><?php echo app('translator')->get('Charge'); ?></span>
                            <span class="text--danger"> <?php echo e(showAmount($transfer->charge)); ?></span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"> <?php echo app('translator')->get('Including Charge'); ?></span>
                            <span class="fw-bold"><?php echo e(showAmount($transfer->final_amount)); ?> </span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"><?php echo app('translator')->get('Send at'); ?></span>
                            <span><?php echo e(showDateTime($transfer->user->created_at, 'd M, Y h:i A')); ?></span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"><?php echo app('translator')->get('TRX No.'); ?></span>
                            <span>#<?php echo e($transfer->trx); ?></span>
                        </li>

                        <li class="list-group-item px-3">
                            <span class="fw-bold"><?php echo app('translator')->get('Status'); ?></span>
                            <?php echo $transfer->statusBadge ?>
                        </li>

                        <?php if($transfer->reject_reason): ?>
                            <li class="list-group-item px-3">
                                <span class="fw-bold"><?php echo app('translator')->get('Reject Reason'); ?></span>
                                <span class="text--danger fw-bold"><?php echo e(__(@$transfer->reject_reason)); ?> </span>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="col-xl-7 col-md-6 mb-30">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title"> <?php echo app('translator')->get('Receiver\'s Information'); ?></h5>
                </div>
                <div class="card-body">

                    <div class="mb-3">
                        <h3 class="text--success fw-bold"><?php echo e(showAmount($transfer->amount)); ?></h3>
                        <small class="text-muted"><?php echo app('translator')->get('Amount'); ?></small>
                    </div>

                    <?php if($transfer->beneficiary): ?>
                        <?php
                            $bank = $transfer->beneficiary->beneficiaryOf;
                            $bankName = $bank->name ?? gs()->site_name;
                        ?>
                        <div class="mb-3">
                            <h6 class="text--info fw-bold"><?php echo e(__($bankName)); ?></h6>
                            <small class="text-muted"><?php echo app('translator')->get('Bank Name'); ?></small>
                        </div>

                        <?php if (isset($component)) { $__componentOriginal42bc7a9986ac561a9c7747ba94199ece = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.view-form-data','data' => ['data' => $transfer->beneficiary->details]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('view-form-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transfer->beneficiary->details)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $attributes = $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $component = $__componentOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
                    <?php else: ?>
                        <?php if (isset($component)) { $__componentOriginal42bc7a9986ac561a9c7747ba94199ece = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.view-form-data','data' => ['data' => @$transfer->wire_transfer_data]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('view-form-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(@$transfer->wire_transfer_data)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $attributes = $__attributesOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__attributesOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece)): ?>
<?php $component = $__componentOriginal42bc7a9986ac561a9c7747ba94199ece; ?>
<?php unset($__componentOriginal42bc7a9986ac561a9c7747ba94199ece); ?>
<?php endif; ?>
                    <?php endif; ?>

                </div>
                <?php if($transfer->status == 0 && (can('admin.transfers.reject') || can('admin.transfers.complete'))): ?>
                    <div class="card-footer d-flex flex-wrap gap-2 p-3">

                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.transfers.complete')): ?>
                            <button class="btn btn-outline--success confirmationBtn" data-action="<?php echo e(route('admin.transfers.complete', $transfer->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to complete this transfer?'); ?>">
                                <i class="las la-check"></i>
                                <?php echo app('translator')->get('Complete'); ?>
                            </button>
                        <?php endif; ?>

                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.transfers.reject')): ?>
                            <button class="btn btn-outline--danger rejectBtn" data-id="<?php echo e($transfer->id); ?>" data-bs-toggle="modal" data-bs-target="#rejectModal" type="button">
                                <i class="fas fa-ban"></i>
                                <?php echo app('translator')->get('Reject'); ?>
                            </button>
                        <?php endif; ?>


                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.transfers.reject')): ?>
        <div class="modal fade" id="rejectModal" role="dialog" tabindex="-1">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('Confirmation Alert!'); ?></h5>
                        <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                            <i class="las la-times"></i>
                        </button>
                    </div>
                    <form action="<?php echo e(route('admin.transfers.reject')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input name="id" type="hidden">
                        <div class="modal-body">
                            <div class="form-group">
                                <label class="fw-bold mt-2"><?php echo app('translator')->get('Reason of Rejection'); ?></label>
                                <textarea class="form-control" name="reject_reason" maxlength="255" rows="5" required><?php echo e(old('message')); ?></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('.rejectBtn').on('click', function() {
                var modal = $('#rejectModal');
                modal.find('input[name=id]').val($(this).data('id'));
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .list-group-item {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            border: 1px solid rgba(0, 0, 0, 0.068);
            padding: 10px 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/transfers/details.blade.php ENDPATH**/ ?>