<?php $__env->startSection('content'); ?>
<div class="pt-100 pb-100">
    <div class="d-flex justify-content-center">
        <div class="verification-code-wrapper custom--card">
            <div class="verification-area">

                
                <?php if($verification->send_via != '2fa'): ?>
                    <?php echo $__env->make($activeTemplate . 'user.otp.email_sms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>

                <?php if($verification->send_via == '2fa'): ?>
                    <p class="text-center mb-3"><?php echo app('translator')->get('Get the OTP code from your Google Authenticator app'); ?></p>
                <?php endif; ?>

                
                <form action="<?php echo e(route('user.otp.submit', $verification->id)); ?>" method="post" class="submit-form">
                    <?php echo csrf_field(); ?>

                    
                    <div class="mb-3">
                        <label for="verification-code"><?php echo app('translator')->get('Enter 6-digit OTP'); ?></label>
                        <input type="text" name="otp" id="verification-code" class="form--control text-center" maxlength="6" required autocomplete="off">
                        <?php $__errorArgs = ['otp'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger d-block mt-2"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    
                    <div class="form-group text-center">
                        <label for="pin"><?php echo app('translator')->get('Enter 4-Digit PIN'); ?></label>
                        <input type="password" name="pin" id="pin" class="form--control pin-input text-center" maxlength="4" readonly required>
                        <?php $__errorArgs = ['pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger d-block mt-2"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                        
                        <div class="pin-keypad mt-3" id="pinKeypad"></div>
                        <div class="d-flex justify-content-center mt-2">
                            <button type="button" class="btn btn-sm btn-danger" onclick="clearPin()">Clear</button>
                        </div>

                        
                        <div class="mt-3">
                            <a href="<?php echo e(route('user.pin.reset')); ?>" class="text--base small"><?php echo app('translator')->get('Forgot PIN? Reset it here'); ?></a>
                        </div>
                    </div>

                    
                    <div class="form-group mb-0">
                        <button type="submit" class="btn btn-md btn--base w-100 mt-3"><?php echo app('translator')->get('Verify'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
    .pin-keypad {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 10px;
        max-width: 200px;
        margin: 0 auto;
    }
    .pin-key {
        padding: 12px;
        font-size: 18px;
        background-color: #f1f1f1;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .pin-key:hover {
        background-color: #ddd;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    // Disable auto-submission
    document.getElementById('verification-code').addEventListener('input', function () {
        let val = this.value;
        if (val.length > 6) {
            this.value = val.slice(0, 6);
        }
    });

    // PIN KEYPAD
    const pinInput = document.getElementById('pin');
    const pinKeypad = document.getElementById('pinKeypad');

    const generateKeys = () => {
        const nums = ['1','2','3','4','5','6','7','8','9','0'];
        const shuffled = nums.sort(() => Math.random() - 0.5);
        pinKeypad.innerHTML = '';
        shuffled.forEach(num => {
            const btn = document.createElement('button');
            btn.textContent = num;
            btn.className = 'pin-key';
            btn.type = 'button';
            btn.onclick = () => {
                if (pinInput.value.length < 4) {
                    pinInput.value += num;
                    generateKeys(); // shuffle on each press
                }
            };
            pinKeypad.appendChild(btn);
        });
    };

    const clearPin = () => {
        pinInput.value = '';
        generateKeys();
    };

    document.addEventListener('DOMContentLoaded', generateKeys);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/user/otp/verify.blade.php ENDPATH**/ ?>