<div class="row justify-content-center gy-4 gx-sm-3 gx-md-4">
    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-4 col-sm-6">
            <div class="plan-card rounded-3 wow fadeInUp gy-3">
                <div class="plan-card__header">
                    <div class="wave-shape">
                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/elements/wave.png')); ?>" alt="img">
                    </div>
                    <h4 class="plan-name"><?php echo e(__($plan->name)); ?></h4>
                    <div class="plan-price"><?php echo e(getAmount($plan->interest_rate)); ?>%<sub>/ <?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?></sub></div>
                </div>
                <div class="plan-card__body text-center">
                    <ul class="plan-feature-list">
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Lock in Period'); ?></span>
                            <?php echo e($plan->locked_days); ?> <?php echo e(__(Str::plural('Day', $plan->locked_days))); ?>

                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Get Profit'); ?> <?php echo app('translator')->get('Every'); ?></span>
                            <?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?>

                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Profit Rate'); ?></span>
                            <?php echo e(getAmount($plan->interest_rate)); ?>%
                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Minimum'); ?> </span>
                            <?php echo e(showAmount($plan->minimum_amount)); ?>

                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Maximum'); ?></span>
                            <?php echo e(showAmount($plan->maximum_amount)); ?>

                        </li>
                    </ul>
                </div>
                <div class="plan-card__footer text-center">
                    <button type="button" data-id="<?php echo e($plan->id); ?>" data-minimum="<?php echo e(showAmount($plan->minimum_amount)); ?>" data-maximum="<?php echo e(showAmount($plan->maximum_amount)); ?>" class="btn btn-md w-100 btn--base fdrBtn"><?php echo app('translator')->get('Apply Now'); ?></button>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $('.fdrBtn').on('click', (e) => {
                let modal = $('#fdrModal');
                let data = e.currentTarget.dataset;
                let form = modal.find('form')[0];
                modal.find('.min-limit').text(`Minimum Amount ${data.minimum}`);
                modal.find('.max-limit').text(`Maximum Amount ${data.maximum}`);
                form.action = `<?php echo e(route('user.fdr.apply', '')); ?>/${data.id}`;
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="fdrModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <?php if(auth()->guard()->check()): ?>
                        <div class="modal-header">
                            <h5 class="modal-title method-name"><?php echo app('translator')->get('Apply to Open an FDR'); ?></h5>
                            <button type="button" class="bg-transparent" data-bs-dismiss="modal" aria-label="Close">
                                <i class="las la-times"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="form-group mt-0">
                                <label><?php echo app('translator')->get('Amount'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" name="amount" class="form--control" placeholder="<?php echo app('translator')->get('Enter An Amount'); ?>" required>
                                    <span class="input-group-text"> <?php echo e(gs()->cur_text); ?> </span>
                                </div>
                                <p><small class="text--danger min-limit mt-2"></small></p>
                                <p><small class="text-danger max-limit"></small></p>
                            </div>
                            <?php echo $__env->make($activeTemplate . 'partials.otp_field', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <button type="submit" class="btn btn-md btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    <?php else: ?>
                        <div class="modal-body">
                            <div class="text-center"><i class="la la-times-circle text--danger la-6x" aria-hidden="true"></i></div>
                            <h3 class="text-center mt-3"><?php echo app('translator')->get('You are not logged in!'); ?></h3>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-sm btn--dark" data-bs-dismiss="modal" aria-label="Close"><?php echo app('translator')->get('Close'); ?></button>
                        </div>
                    <?php endif; ?>

                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/partials/fdr_plans.blade.php ENDPATH**/ ?>