<?php $__env->startSection('panel'); ?>
    <?php
        $request = request();
        $tableName = 'users_list';
        $branches = App\Models\Branch::orderBy('name')->get()->pluck('name')->toArray();
        $branches[] = 'Online';

        $tableConfiguration = $tableConfiguration = tableConfiguration($tableName);
        $countries = json_decode(file_get_contents(resource_path('views/partials/country.json')));

        $countries = collect($countries)->map(function($country){
            return $country->country;
        });

        $countryOptions = array_values($countries->toArray());

        $columns = collect([
            prepareTableColumn('account_number', 'Account No.'),
            prepareTableColumn('username', 'Username'),
            prepareTableColumn('fullname', 'Name'),
            prepareTableColumn('email', 'Email'),
            prepareTableColumn('mobile', 'Mobile'),
            prepareTableColumn('country_name', 'Country', filter: 'select', filterOptions: $countryOptions),
            prepareTableColumn('state', 'State', filter: 'text'),
            prepareTableColumn('city', 'City', filter: 'text'),
            prepareTableColumn('zip', 'Zip', filter: 'text'),
            prepareTableColumn('branch_name', 'Branch', filter: 'select', filterColumn: 'branch_name', filterOptions: $branches),
            prepareTableColumn('balance', 'Balance', 'showAmount($item->balance)', filter: 'range'),
            prepareTableColumn('created_at', 'Registered At', 'showDateTime("$item->created_at", "d M, Y")', filter: 'date')
        ]);

        $action = [
            'name' => 'Action',
            'style' => 'dropdown',
            'show' => can('admin.users.detail') || can('admin.users.kyc.details') || can('admin.users.login') || can('admin.report.login.history') || can('admin.users.notification.log') || can('admin.users.notification.single'),
            'buttons' => [
                [
                    'name' => 'View Details',
                    'link' => 'route("admin.users.detail", $item->id)',
                    'show' => can('admin.users.detail'),
                ],
                [
                    'name' => 'View KYC Data',
                    'link' => 'route("admin.users.kyc.details", $item->id)',
                    'show' => can('admin.users.kyc.details'),
                ],
                [
                    'name' => 'Login As User',
                    'link' => 'route("admin.users.login", $item->id)',
                    'show' => can('admin.users.login'),
                    'attributes' => [
                        'target' => "json_encode('blank')"
                    ]
                ],
                [
                    'name' => 'Login History',
                    'link' => 'route("admin.report.login.history", $item->id)',
                    'show' => can('admin.report.login.history'),
                ],
                [
                    'name' => 'Send Notification',
                    'link' => 'route("admin.users.notification.single", $item->id)',
                    'show' => can('admin.users.notification.single'),
                ],
                [
                    'name' => 'All Notifications',
                    'link' => 'route("admin.users.notification.log", $item->id)',
                    'show' => can('admin.users.notification.log'),
                ],
            ],
        ];

        if($tableConfiguration){
            $visibleColumns = $tableConfiguration->visible_columns;
        }else{
            $visibleColumns = $columns->pluck('id')->toArray();
        }
    ?>

    <?php if (isset($component)) { $__componentOriginala9d13211d16a9b68016cb700b31e0809 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala9d13211d16a9b68016cb700b31e0809 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table','data' => ['data' => $users,'columns' => $columns,'action' => $action,'columnConfig' => true,'tableName' => $tableName,'visibleColumns' => $visibleColumns,'class' => 'table-responsive--md table-responsive']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($users),'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($columns),'action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($action),'columnConfig' => true,'tableName' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableName),'visibleColumns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($visibleColumns),'class' => 'table-responsive--md table-responsive']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $attributes = $__attributesOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__attributesOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $component = $__componentOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__componentOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php if($users->total() > 0 && can('admin.users.notification.all.send')): ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <a href="<?php echo e(appendQuery('notify', 1)); ?>" class="btn btn--dark">
        <i class="fas fa-bell"></i>
        <?php echo app('translator')->get('Notify'); ?> <strong class="mx-1"><?php echo e($users->total()); ?></strong> <?php echo e(__(str_replace('All', '' ,$pageTitle))); ?> <?php echo app('translator')->get('Holders'); ?>
        <?php if($request->has('filter')): ?>(<?php echo app('translator')->get('Filtered'); ?>)<?php endif; ?>
    </a>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/users/list.blade.php ENDPATH**/ ?>