<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title><?php echo e(gs()->siteName($pageTitle ?? '')); ?></title>
    <!-- favicon -->
    <link rel="shortcut icon" type="image/png" href="<?php echo e(siteFavicon()); ?>">

    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/pdf.css')); ?>">

    <?php echo $__env->yieldPushContent('style'); ?>
</head>

<body>
    
<div style="
    position: absolute;
    top: 40%;
    left: 50%;
    transform: translate(-50%, -50%) rotate(-15deg);
    opacity: 0.12;
    z-index: 0;
    font-size: 28px;
    font-weight: bold;
    color: #28a745;
    border: 5px dashed #28a745;
    border-radius: 50%;
    padding: 50px 100px;
    text-align: center;
    pointer-events: none;
    text-transform: uppercase;
    letter-spacing: 1px;
    white-space: nowrap;
">
    <?php echo e(strtoupper(gs()->site_name)); ?><br>
    <?php echo e(now()->format('Y-m-d')); ?>

</div>

    <main>
        <div class="list--row">
            <div class="address-to float-left">
                <h5 class="page-title"><?php echo e(@$pageTitle); ?></h5>
                <?php if(request()->date): ?>
                    <p class="text-small"><?php echo app('translator')->get('Date'); ?>: <?php echo e(request()->date); ?></p>
                <?php endif; ?>

                <?php if(request()->search): ?>
                    <p class="text-small"><?php echo app('translator')->get('Search Key'); ?>: <?php echo e(request()->search); ?></p>
                <?php endif; ?>
            </div>

            <div class="address-form float-right">
                <ul class="text-center">
                    <li>
                        <img src="<?php echo e(siteLogo('dark')); ?>" class="logo" alt="Logo">
                    </li>
                </ul>
            </div>
        </div>

        <div class="body">
            <?php echo $__env->yieldContent('main-content'); ?>
        </div>
    </main>

    <footer>
        <div class="d-block text-center">
            <?php echo app('translator')->get('Powered by'); ?> <?php echo e(__(gs()->site_name)); ?>

        </div>
    </footer>
</body>

</html><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/pdf/layouts/master.blade.php ENDPATH**/ ?>