<?php
    $footer = getContent('footer.content', true);
    $datas = getContent('footer.element');
    $contacts = getContent('contact_us.element');
    $about = getContent('about.content', true);
    $links = getContent('policy_pages.element', false, null, true);
?>

<footer class="footer position-relative z-index-2">
    <div class="container">
        <div class="row gy-4">
            <div class="col-lg-4 col-sm-6 order-lg-1 order-1">
                <div class="footer-widget">
                    <h3 class="footer-widget__title"><?php echo app('translator')->get('About Us'); ?></h3>
                    <p><?php echo e(__(@$about->data_values->subheading)); ?></p>
                    <ul class="social-media-links d-flex align-items-center mt-3">
                        <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($data->data_values->social_link); ?>" target="_blank">
                                    <?php echo $data->data_values->social_icon; ?>
                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6 order-lg-2 order-3">
                <div class="footer-widget">
                    <h3 class="footer-widget__title"><?php echo app('translator')->get('Quick Links'); ?></h3>
                    <ul class="short-link-list">
                        <?php if(auth()->guard()->check()): ?>
                            <li><a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('User Dashboard'); ?></a></li>
                        <?php else: ?>
                            <?php if(gs('registration')): ?>
                                <li><a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a></li>
                            <?php endif; ?>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('branches')); ?>"><?php echo app('translator')->get('Our Branches'); ?></a></li>
                        <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6 order-lg-3 order-4">
                <div class="footer-widget">
                    <h3 class="footer-widget__title"><?php echo app('translator')->get('Page'); ?></h3>
                    <ul class="short-link-list">
                        <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e(route('policy.pages',$link->slug)); ?>">
                                    <?php echo e(__($link->data_values->title)); ?>

                                </a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 order-lg-4 order-2">
                <div class="footer-widget">
                    <h3 class="footer-widget__title"><?php echo app('translator')->get('Contact Us'); ?></h3>
                    <ul class="footer-info-list">
                        <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <?php echo $contact->data_values->icon; ?>
                                <p><?php echo e($contact->data_values->address); ?></p>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            </div>
        </div>
        <div class="footer__bottom">
            <div class="row gy-4 align-items-center">
                <div class="col-lg-3 col-sm-6 order-lg-1 text-sm-start order-1 text-center">
                    <a class="footer-logo" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(siteLogo()); ?>" alt="<?php echo app('translator')->get('Logo'); ?>"></a>
                </div>

                <div class="col-lg-9 col-sm-6 order-lg-3 text-sm-end order-2 text-center">
                    <p><?php echo e(__(@$footer->data_values->text)); ?></p>
                </div>
            </div>
        </div>
    </div>
</footer>

<?php
    $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
?>

<?php if($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie')): ?>
    <div class="cookies-card hide text-center">
        <div class="cookies-card__icon bg--base">
            <i class="las la-cookie-bite"></i>
        </div>
        <p class="cookies-card__content mt-4"><?php echo e(@$cookie->data_values->short_desc); ?> <a href="<?php echo e(route('cookie.policy')); ?>" target="_blank"><?php echo app('translator')->get('Learn more'); ?></a></p>
        <div class="cookies-card__btn mt-4">
            <a class="btn btn--base w-100 policy" href="javascript:void(0)"><?php echo app('translator')->get('Allow'); ?></a>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/partials/footer.blade.php ENDPATH**/ ?>