<?php $__env->startPush('topBar'); ?>
    <?php echo $__env->make('admin.staff.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>

    <?php
        $request = request();
        $tableName = 'staff_list';

        $tableConfiguration = $tableConfiguration = tableConfiguration($tableName);
        $roleOptions = $roles->pluck('name')->toArray();
        sort($roleOptions);

        $statusOptions = ['Active', 'Banned'];

        $columns = collect([
            prepareTableColumn('username', 'Username'),
            prepareTableColumn('name', 'Name'),
            prepareTableColumn('email', 'Email'),
            prepareTableColumn('role_name', 'Role', filter: 'select', filterOptions: $roleOptions),
            prepareTableColumn('status_text', 'Status', '$item->status_badge', filter:'select', filterOptions:$statusOptions, echoable:true),
            prepareTableColumn('created_at', 'Added On', 'showDateTime("$item->created_at", "d M, Y")', filter: 'date')
        ]);

        $action = [
            'name' => 'Action',
            'style' => 'dropdown',
            'show' => can("admin.staff.save") && can("admin.staff.status") && can("admin.staff.login"),
            'buttons' => [
                [
                    'name' => 'Edit',
                    'show' => 'can("admin.staff.save") && $item->id > 1',
                    'class' => 'cuModalBtn',
                    'icon'=> 'la la-pencil',
                    'attributes' => [
                        'data-resource' => 'json_encode($item) ',
                        'data-modal_title' => 'trans("Update Staff")'
                    ]
                ],
                [
                    'name' => 'Ban',
                    'show' => 'can("admin.staff.status") && $item->status && $item->id > 1',
                    'class' => 'confirmationBtn',
                    'icon'=> 'la la-user-times',
                    'attributes' => [
                        'data-action' => 'route(\'admin.staff.status\', $item->id)',
                        'data-question' => 'trans("Are you sure to ban this staff?")'
                    ]
                ],
                [
                    'name' => 'Unban',
                    'show' => 'can("admin.staff.status") && !$item->status && $item->id > 1',
                    'class' => 'confirmationBtn',
                    'icon'=> 'la la-user-check',
                    'attributes' => [
                        'data-action' => 'route(\'admin.staff.status\', $item->id)',
                        'data-question' => 'trans("Are you sure to ban this staff?")'
                    ]
                ],
                [
                    'name' => 'Login As Staff',
                    'icon' => 'la la-sign-in-alt',
                    'link' => 'route("admin.staff.login", $item->id)',
                    'show' => 'can("admin.staff.login") && $item->id > 1',
                ]
            ],
        ];

        if($tableConfiguration){
            $visibleColumns = $tableConfiguration->visible_columns;
        }else{
            $visibleColumns = $columns->pluck('id')->toArray();
        }
    ?>



    <?php if (isset($component)) { $__componentOriginala9d13211d16a9b68016cb700b31e0809 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala9d13211d16a9b68016cb700b31e0809 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table','data' => ['data' => $allStaff,'columns' => $columns,'action' => $action,'columnConfig' => true,'tableName' => $tableName,'visibleColumns' => $visibleColumns,'class' => 'table-responsive--md table-responsive']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($allStaff),'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($columns),'action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($action),'columnConfig' => true,'tableName' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableName),'visibleColumns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($visibleColumns),'class' => 'table-responsive--md table-responsive']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $attributes = $__attributesOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__attributesOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $component = $__componentOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__componentOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>

    <!-- Create Update Modal -->
    <div class="modal fade" id="cuModal">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add New Staff'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>

                <form action="<?php echo e(route('admin.staff.save')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control" name="name" required>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Username'); ?></label>
                            <input type="text" class="form-control" name="username" required>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Email'); ?></label>
                            <input type="email" class="form-control" name="email" required>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Role'); ?></label>
                            <select name="role_id" class="form-control" required>
                                <option value="" disabled selected><?php echo app('translator')->get('Select One'); ?></option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($role->id); ?>"><?php echo e($role->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Password'); ?></label>
                            <div class="input-group">
                                <input class="form-control" name="password" type="text" required>
                                <button class="input-group-text generatePassword" type="button"><?php echo app('translator')->get('Generate'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.staff.save')): ?>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.staff.save')): ?>
        <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn" data-modal_title="<?php echo app('translator')->get('Add New Staff'); ?>">
            <i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?>
        </button>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/cu-modal.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.generatePassword').on('click', function() {
                $(this).siblings('[name=password]').val(generatePassword());
            });

            $('.cuModalBtn').on('click', function() {
                let passwordField = $('#cuModal').find($('[name=password]'));
                let label = passwordField.parents('.form-group').find('label')
                if ($(this).data('resource')) {
                    passwordField.removeAttr('required');
                    label.removeClass('required')
                } else {
                    passwordField.attr('required', 'required');
                    label.addClass('required')
                }
            });


            function generatePassword(length = 12) {
                let charset = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+<>?/";
                let password = '';
                for (var i = 0, n = charset.length; i < length; ++i) {
                    password += charset.charAt(Math.floor(Math.random() * n));
                }

                return password
            }

            if (new URLSearchParams(window.location.search).has('addnew')) {
                let cuModal = new bootstrap.Modal(document.getElementById('cuModal'));
                cuModal.show();
            }

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/staff/index.blade.php ENDPATH**/ ?>