<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center mt-4">
        <div class="col-xl-7 col-lg-12">
            <div class="card custom--card">
                <div class="card-body">
                    <h5 class="text-center">
                        <?php echo app('translator')->get('You have requested to invest in DPS'); ?>
                    </h5>
                    <p class="text--danger text-center">(<?php echo app('translator')->get('Be Sure Before Confirm'); ?>)</p>

                    <ul class="caption-list-two mt-3">
                        <li>
                            <span class="caption"><?php echo app('translator')->get('Plan'); ?></span>
                            <span class="value"><?php echo e(__($plan->name)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Installment Interval'); ?></span>
                            <span class="value"><?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Total Installment'); ?></span>
                            <span class="value"><?php echo e($plan->total_installment); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Per Installment'); ?></span>
                            <span class="value"><?php echo e(showAmount($plan->per_installment)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Total Deposit'); ?></span>
                            <span class="value"><?php echo e(showAmount($plan->per_installment * $plan->total_installment)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Profit Rate'); ?></span>
                            <span class="value"><?php echo e(getAmount($plan->interest_rate)); ?>%</span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Withdrawable Amount'); ?></small></span>
                            <span class="value fw-bold"><?php echo e(showAmount($plan->final_amount)); ?></span>
                        </li>
                    </ul>

                    <p class="px-2">
                        <?php if($plan->delay_value && $plan->delay_charge): ?>
                            <small class="text--danger">*
                                <?php echo app('translator')->get('If an installment is delayed for'); ?>
                                <span class="fw-bold"><?php echo e($plan->delay_value); ?></span> <?php echo app('translator')->get('or more days then, an amount of'); ?>, <span class="fw-bold"><?php echo e(gs()->cur_sym . $plan->delayCharge); ?></span> <?php echo app('translator')->get('will be applied for each day.'); ?>
                            </small>

                            <br>

                            <small class="text--danger">
                                * <?php echo app('translator')->get('The total charge amount will be subtracted from the withdrawable amount.'); ?>
                            </small>
                        <?php endif; ?>
                    </p>

                    <div class="d-flex justify-content-end mt-3 gap-2">
                        <a class="btn btn-md btn--dark" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Cancel'); ?></a>

                        <form action="<?php echo e(route('user.dps.apply.confirm', $verificationId)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <button class="btn btn-md btn--base" type="submit"><?php echo app('translator')->get('Confirm'); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('bottom-menu'); ?>
    <li><a href="<?php echo e(route('user.dps.plans')); ?>"><?php echo app('translator')->get('DPS Plans'); ?></a></li>
    <li><a href="<?php echo e(route('user.dps.list')); ?>"><?php echo app('translator')->get('My DPS List'); ?></a></li>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/user/dps/preview.blade.php ENDPATH**/ ?>