<?php $__env->startSection('panel'); ?>
    <?php
        $request = request();
        $tableName = 'other_banks';

        $tableConfiguration = $tableConfiguration = tableConfiguration($tableName);

        $statusOptions = ['1'=>'Active', '0'=>'Banned'];

        $columns = collect([
            prepareTableColumn('name', 'Bank'),
            prepareTableColumn('minimum_limit', 'Min Limit', 'showAmount("$item->minimum_limit")', filter: 'range'),
            prepareTableColumn('maximum_limit', 'Max Limit', 'showAmount("$item->maximum_limit")', filter: 'range'),
            prepareTableColumn('daily_maximum_limit', 'Daily Max Limit', 'showAmount("$item->daily_maximum_limit")', filter: 'range'),
            prepareTableColumn('monthly_maximum_limit', 'Monthly Max Limit', 'showAmount("$item->monthly_maximum_limit")', filter: 'range'),
            prepareTableColumn('daily_total_transaction', 'Daily Total Trx.', 'showAmount("$item->daily_total_transaction")', filter: 'range'),
            prepareTableColumn('monthly_total_transaction', 'Daily Total Trx.', 'showAmount("$item->monthly_total_transaction")', filter: 'range'),
            prepareTableColumn('fixed_charge', 'Fixed Charge', 'showAmount("$item->fixed_charge")', filter: 'range'),
            prepareTableColumn('percent_charge', 'Percent Charge', 'getAmount("$item->percent_charge")."%"', filter: 'range'),
            prepareTableColumn('processing_time', 'Processing Time', filter:'text'),
            prepareTableColumn('status', 'Status', '$item->status_badge', filter:'select', filterOptions:$statusOptions, echoable:true),
        ]);

        $action = [
            'name' => 'Action',
            'style' => 'dropdown',
            'show' => can('admin.bank.edit') || can('admin.bank.change.status'),
            'buttons' => [
                [
                    'name' => 'Edit',
                    'icon' => 'la la-pencil',
                    'link' => 'route("admin.bank.edit", $item->id)',
                    'show' => can('admin.bank.edit'),
                ],
                [
                    'name' => 'Disable',
                    'show' => 'can("admin.bank.change.status") && $item->status',
                    'class' => 'confirmationBtn',
                    'icon'=> 'la la-eye-slash',
                    'attributes' => [
                        'data-action' => 'route(\'admin.bank.change.status\', $item->id)',
                        'data-question' => 'trans("Are you sure to disable this bank?")'
                    ]
                ],
                [
                    'name' => 'Enable',
                    'show' => 'can("admin.bank.change.status") && !$item->status',
                    'class' => 'confirmationBtn',
                    'icon'=> 'la la-eye',
                    'attributes' => [
                        'data-action' => 'route(\'admin.bank.change.status\', $item->id)',
                        'data-question' => 'trans("Are you sure to enable this bank?")'
                    ]
                ]

            ],
        ];

        if($tableConfiguration){
            $visibleColumns = $tableConfiguration->visible_columns;
        }else{
            $visibleColumns = $columns->pluck('id')->toArray();
        }
    ?>

    <?php if (isset($component)) { $__componentOriginala9d13211d16a9b68016cb700b31e0809 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala9d13211d16a9b68016cb700b31e0809 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table','data' => ['data' => $banks,'columns' => $columns,'action' => $action,'columnConfig' => true,'tableName' => $tableName,'visibleColumns' => $visibleColumns,'class' => 'table-responsive--md table-responsive','searchPlaceholder' => 'Bank Name']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($banks),'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($columns),'action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($action),'columnConfig' => true,'tableName' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableName),'visibleColumns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($visibleColumns),'class' => 'table-responsive--md table-responsive','searchPlaceholder' => 'Bank Name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $attributes = $__attributesOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__attributesOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $component = $__componentOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__componentOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>


    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.bank.change.status')): ?>
        <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.bank.create')): ?>
        <a class="btn btn-outline--primary" href="<?php echo e(route('admin.bank.create')); ?>">
            <i class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?>
        </a>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/other_banks/index.blade.php ENDPATH**/ ?>