<?php
    $hour = now()->hour;

    $user = auth()->user();
    $name = $user->firstname ?? $user->name ?? 'User';

    // ✅ Use the working image path
    $image = getImage(getFilePath('userProfile') . '/' . $user->image, null, true);

    if ($hour >= 5 && $hour < 12) {
        $greeting = 'Good Morning';
    } elseif ($hour >= 12 && $hour < 18) {
        $greeting = 'Good Afternoon';
    } else {
        $greeting = 'Good Evening';
    }

    $pageTitle = $greeting . ', ' . $name .
        '<br><img src="' . $image . '" alt="User Image" style="width: 80px; height: 80px; border-radius: 50%; margin-top: 10px;">';
    $kyc = getContent('kyc_content.content', true);
?>
<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center gy-4">
        <?php if($user->kv != Status::KYC_VERIFIED): ?>
            <div class="col-lg-12">
                <?php
                    $kyc = getContent('kyc.content', true);
                ?>
                <?php if($user->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
                    <div class="card-widget section--bg2" role="alert">
                        <div class="d-flex justify-content-between align-items-center">
                            <h4 class="text--danger"><?php echo app('translator')->get('KYC Documents Rejected'); ?></h4>
                            <button class="btn btn--base btn-sm" data-bs-toggle="modal" data-bs-target="#kycRejectionReason"><?php echo app('translator')->get('Show Reason'); ?></button>
                        </div>
                        <hr>
                        <p class="text-white mb-2"><?php echo e(__(@$kyc->data_values->reject)); ?></p>

                        <a href="<?php echo e(route('user.kyc.form')); ?>"><?php echo app('translator')->get('Click Here to Re-submit Documents'); ?></a>
                        <br>
                        <a href="<?php echo e(route('user.kyc.data')); ?>"><?php echo app('translator')->get('See KYC Data'); ?></a>
                    </div>
                <?php elseif(auth()->user()->kv == Status::KYC_UNVERIFIED): ?>
                    <div class="card-widget section--bg2" role="alert">
                        <h4 class="text--base"><?php echo app('translator')->get('KYC Verification required'); ?></h4>
                        <hr>
                        <p class="mb-0 text-white"><?php echo e(__(@$kyc->data_values->required)); ?> <a href="<?php echo e(route('user.kyc.form')); ?>" class="text--base"><?php echo app('translator')->get('Click Here to Verify'); ?></a></p>
                    </div>
                <?php elseif(auth()->user()->kv == Status::KYC_PENDING): ?>
                    <div class="card-widget section--bg2" role="alert">
                        <h4 class="text--base"><?php echo app('translator')->get('KYC Verification pending'); ?></h4>
                        <hr>
                        <p class="mb-0 text-white"><?php echo e(__(@$kyc->data_values->pending)); ?> <a href="<?php echo e(route('user.kyc.data')); ?>" class="text--base"><?php echo app('translator')->get('See KYC Data'); ?></a></p>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="col-lg-6">
            <div class="card-widget section--bg2 text-center bg_img" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                <span class="caption text-white mb-3"><?php echo app('translator')->get('Account Number'); ?></span>
                <h3 class="d-number text-white"><?php echo e($user->account_number); ?></h3>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="card-widget section--bg2 text-center bg_img" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                <span class="caption text-white mb-3"><?php echo app('translator')->get('Available Balance'); ?></span>
                <h3 class="d-number text-white"><?php echo e(showAmount($user->balance)); ?></h3>
            </div>
        </div>

        <?php if(@gs()->modules->deposit): ?>
            <div class="col-lg-4 col-md-6">
                <a href="<?php echo e(route('user.deposit.history')); ?>" class="w-100 h-100">
                    <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                        <div class="d-widget__content">
                            <h3 class="d-number text-white">
                                <?php echo e(showAmount(@$widget['total_deposit'])); ?>

                            </h3>
                            <span class="caption text-white"><?php echo app('translator')->get('Pending Deposits'); ?></span>
                        </div>
                        <div class="d-widget__icon border-radius--100">
                            <i class="las la-wallet"></i>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
        <?php if(@gs()->modules->withdraw): ?>
            <div class="col-lg-4 col-md-6">
                <a href="<?php echo e(route('user.withdraw.history')); ?>" class="w-100 h-100">
                    <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                        <div class="d-widget__content">
                            <h3 class="d-number text-white"><?php echo e(showAmount(@$widget['total_withdraw'])); ?></h3>
                            <span class="caption text-white"><?php echo app('translator')->get('Pending Withdrawals'); ?></span>
                        </div>
                        <div class="d-widget__icon border-radius--100">
                            <i class="las la-money-check"></i>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
        <div class="col-lg-4 col-md-6">
            <a href="<?php echo e(route('user.transaction.history')); ?>" class="w-100 h-100">
                <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                    <div class="d-widget__content">
                        <h3 class="d-number text-white"><?php echo e(@$widget['total_trx']); ?></h3>
                        <span class="caption text-white"><?php echo app('translator')->get('Today Transactions'); ?></span>
                    </div>
                    <div class="d-widget__icon border-radius--100">
                        <i class="las la-exchange-alt"></i>
                    </div>
                </div>
            </a>
        </div>
        <?php if(gs()->modules->fdr): ?>
            <div class="col-lg-4 col-md-6">
                <a href="<?php echo e(route('user.fdr.list')); ?>" class="w-100 h-100">
                    <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url(' <?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                        <div class="d-widget__content">
                            <h3 class="d-number text-white"><?php echo e(@$widget['total_fdr']); ?></h3>
                            <span class="caption text-white"><?php echo app('translator')->get('Running FDR'); ?></span>
                        </div>
                        <div class="d-widget__icon border-radius--100">
                            <i class="las la-money-bill"></i>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
        <?php if(gs()->modules->dps): ?>
            <div class="col-lg-4 col-md-6">
                <a href="<?php echo e(route('user.dps.list')); ?>" class="w-100 h-100">
                    <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url('<?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                        <div class="d-widget__content">
                            <h3 class="d-number text-white"><?php echo e(@$widget['total_dps']); ?></h3>
                            <span class="caption text-white"><?php echo app('translator')->get('Running DPS'); ?></span>
                        </div>
                        <div class="d-widget__icon border-radius--100">
                            <i class="las la-box-open"></i>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
        <?php if(gs()->modules->loan): ?>
            <div class="col-lg-4 col-md-6">
                <a href="<?php echo e(route('user.loan.list')); ?>" class="w-100 h-100">
                    <div class="d-widget section--bg2 d-flex flex-wrap align-items-center rounded-3 bg_img h-100" style="background-image: url('<?php echo e(asset($activeTemplateTrue . 'images/elements/card-bg.png')); ?> ');">
                        <div class="d-widget__content">
                            <h3 class="d-number text-white"><?php echo e(@$widget['total_loan']); ?></h3>
                            <span class="caption text-white"><?php echo app('translator')->get('Running Loan'); ?></span>
                        </div>
                        <div class="d-widget__icon border-radius--100">
                            <i class="las la-hand-holding-usd"></i>
                        </div>
                    </div>
                </a>
            </div>
        <?php endif; ?>
    </div>

    <?php if(gs()->modules->referral_system): ?>
        <div class="row gy-4 mt-3">
            <div class="col-12">
                <div class="d-widget d-flex flex-wrap align-items-center rounded-3">
                    <label for="lastname" class="col-form-label"><?php echo app('translator')->get('My Referral Link'); ?>:</label>
                    <div class="input-group">
                        <input type="url" id="ref" value="<?php echo e(route('home') . '?reference=' . auth()->user()->username); ?>" class="form--control bg-transparent" readonly>
                        <button type="button" class="input-group-text bg--base copyBtn border-0 text-white"><i class="fa fa-copy"></i> &nbsp; <?php echo app('translator')->get('Copy'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="row gy-4 mt-3">
        <div class="col-lg-6">
            <h4 class="mb-3"><?php echo app('translator')->get('Latest Credits'); ?></h3>
                <div class="custom--card">
                    <div class="card-body p-0">
                        <div class="table-responsive--md">
                            <table class="table custom--table mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('TRX'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                        <th><?php echo app('translator')->get('Time'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>#<?php echo e($credit->trx); ?></td>
                                            <td class="fw-bold"><?php echo e(showAmount($credit->amount)); ?></td>
                                            <td><?php echo e(showDateTime($credit->created_at, 'd M, Y h:i A')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
        </div>
        <div class="col-lg-6">
            <h4 class="mb-3"><?php echo app('translator')->get('Latest Debits'); ?></h3>
                <div class="custom--card">
                    <div class="card-body p-0">
                        <div class="table-responsive--md">
                            <table class="table custom--table mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('Trx'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                        <th><?php echo app('translator')->get('Time'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $debits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $debit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>#<?php echo e($debit->trx); ?></td>
                                            <td class="fw-bold"><?php echo e(showAmount($debit->amount)); ?></td>
                                            <td><?php echo e(showDateTime($debit->created_at, 'd M, Y h:i A')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
    <?php $__env->startPush('modal'); ?>
        <div class="modal fade" id="kycRejectionReason">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p><?php echo e(auth()->user()->kyc_rejection_reason); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $('.copyBtn').on('click', function() {
                var copyText = $(this).siblings('#ref')[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
                copyText.blur();
                $(this).addClass('copied');
                setTimeout(() => {
                    $(this).removeClass('copied');
                }, 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/user/dashboard.blade.php ENDPATH**/ ?>