<?php foreach ((['columns', 'tableName', 'visibleColumns', 'columnConfig', 'searchPlaceholder']) as $__key => $__value) {
    $__consumeVariable = is_string($__key) ? $__key : $__value;
    $$__consumeVariable = is_string($__key) ? $__env->getConsumableComponentData($__key, $__value) : $__env->getConsumableComponentData($__value);
} ?>
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['filterable', 'rows', 'sortable', 'exportable', 'searchable']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['filterable', 'rows', 'sortable', 'exportable', 'searchable']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $request = request();
?>

<div class="align-items-start d-flex flex-wrap flex-md-nowrap justify-content-between gap-3 table-options">
    <div class="d-flex flex-wrap gap-2 gap-md-3 align-items-center">

        
        <?php if($rows): ?>
            <?php
                $perPage = $request->per_page?? gs('paginate_number');
            ?>

            <div class="d-inline-flex align-items-center">
                <select name="per_page" class="form-select">
                    <option value="" disabled selected><?php echo app('translator')->get('Rows'); ?></option>
                    <?php for($i = 5; $i <= 200; $i+=5): ?>
                        <option value="<?php echo e($i); ?>" <?php if($perPage == $i): echo 'selected'; endif; ?>><?php echo e($i); ?></option>
                    <?php endfor; ?>
                </select>
            </div>
        <?php endif; ?>

        
        <?php if($sortable): ?>
            <div class="d-inline-flex align-items-center">
                <?php
                    $orderByColumns = $columns->whereIn('id', $visibleColumns)->where('sortable', true)->all();
                ?>

                <div class="input-group flex-nowrap">
                    <select name="order_by_column" class="order-data form-select">
                        <option value="" disabled selected><i class="la la-sort"></i><?php echo app('translator')->get('Sort By'); ?></option>
                        <?php $__currentLoopData = $orderByColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($column['id']); ?>" <?php if(@$request->order_by_column == $column['id']): echo 'selected'; endif; ?>><?php echo e(__($column['name'])); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <select name="order_by" class="order-data form-select">
                        <option value="desc" <?php if(@$request->order_by == 'desc'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Desc'); ?></option>
                        <option value="asc" <?php if(@$request->order_by == 'asc'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Asc'); ?></option>
                    </select>

                    <?php if($request->has('order_by_column') || $request->has('order_by')): ?>
                        <button class="input-group-text clearOrderBy" href=""><i class="la la-redo-alt"></i></button>
                    <?php endif; ?>
                </div>
            </div>


        <?php endif; ?>

        <?php if($exportable): ?>
            <button class="table-option-btn" id="exportBtn"> <i class="la la-download"></i> <?php echo app('translator')->get('Export'); ?></button>
        <?php endif; ?>

        <?php if($columnConfig): ?>
            <div class="dropdown text--14">
                <button aria-expanded="false" class="table-option-btn" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
                    <i class="la la-eye"></i>
                    <?php echo app('translator')->get('Columns'); ?>
                </button>

                <div class="dropdown-menu p-3">
                    <form action="<?php echo e(route('admin.table.configure')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="name" value="<?php echo e(@$tableName); ?>">

                        <?php $__currentLoopData = $columns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="form-check">
                                <input type="checkbox" name="visible_columns[]" id="column-<?php echo e($column['id']); ?>" class="form-check-input" value="<?php echo e($column['id']); ?>" checked>
                                <label class="form-check-label" for="column-<?php echo e($column['id']); ?>"><?php echo e($column['name']); ?></label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <button type="submit" class="btn btn--primary px-3 w-100 mt-2"><?php echo app('translator')->get('Apply'); ?></button>
                    </form>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <?php if($columnConfig || $searchable || $filterable): ?>
        <div class="d-flex gap-2 gap-md-3 justify-content-between align-items-center flex-grow-1 flex-md-grow-0 flex-shrink-0 flex-row-reverse flex-md-row">

            <?php if($searchable): ?>
                <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['btn' => 'input-group-text py-0 btn--light border','placeholder' => @$searchPlaceholder]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['btn' => 'input-group-text py-0 btn--light border','placeholder' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(@$searchPlaceholder)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
            <?php endif; ?>

            <?php if($filterable): ?>
                <button class="table-option-btn" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasRight" aria-controls="offcanvasRight"><i class="la la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
            <?php endif; ?>
        </div>
    <?php endif; ?>
</div>

<?php if($filterable): ?>
    <?php if (isset($component)) { $__componentOriginal73f2d6f064c85b00be078294d541da2d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal73f2d6f064c85b00be078294d541da2d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table-filter','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table-filter'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal73f2d6f064c85b00be078294d541da2d)): ?>
<?php $attributes = $__attributesOriginal73f2d6f064c85b00be078294d541da2d; ?>
<?php unset($__attributesOriginal73f2d6f064c85b00be078294d541da2d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal73f2d6f064c85b00be078294d541da2d)): ?>
<?php $component = $__componentOriginal73f2d6f064c85b00be078294d541da2d; ?>
<?php unset($__componentOriginal73f2d6f064c85b00be078294d541da2d); ?>
<?php endif; ?>
<?php endif; ?>

<?php if($exportable): ?>
    <div class="modal fade" id="exportModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="exportModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-scrollable">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exportModalLabel"><?php echo app('translator')->get('Export Data'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="la la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="tableExportForm">
                        <input type="hidden" name="file_name" value="<?php echo e($tableName); ?>">
                        <div class="mb-3">
                            <label><?php echo app('translator')->get('Select Columns'); ?></label>
                            <div class="columns-container"></div>
                        </div>
                        <div class="mb-3">
                            <label for="export-as"><?php echo app('translator')->get('Export As'); ?></label>
                            <select class="form-control" name="export_type" id="export-as" required>
                                <option value="" hidden selected><?php echo app('translator')->get('Select One'); ?></option>
                                <option type="option" value="excel"><?php echo app('translator')->get('Excel'); ?></option>
                                <option type="option" value="csv"><?php echo app('translator')->get('CSV'); ?></option>
                                <option type="option" value="pdf"><?php echo app('translator')->get('PDF'); ?></option>
                                <option type="button" value="print"><?php echo app('translator')->get('Print'); ?></option>
                            </select>
                        </div>

                        <div class="pdf-configuration d-none">
                            <div class="mb-3">
                                <label for="export-as">
                                    <?php echo app('translator')->get('Heading'); ?> <i class="la la-info-circle" title="<?php echo app('translator')->get('The Heading will be displayed in the top of the first page'); ?>"></i>
                                </label>
                                <input type="text" class="form-control" name="heading">
                            </div>

                            <div class="mb-3">
                                <label for="page-size"><?php echo app('translator')->get('Page Size'); ?></label>
                                <select class="form-control" name="page_size" id="page-size" required>
                                    <option value="" hidden selected><?php echo app('translator')->get('Select One'); ?></option>
                                    <option type="option" value="a0"><?php echo app('translator')->get('A0'); ?></option>
                                    <option type="option" value="a1"><?php echo app('translator')->get('A1'); ?></option>
                                    <option type="option" value="a2"><?php echo app('translator')->get('A2'); ?></option>
                                    <option type="option" value="a3"><?php echo app('translator')->get('A3'); ?></option>
                                    <option type="button" value="a4" selected><?php echo app('translator')->get('A4'); ?></option>
                                    <option type="button" value="a5"><?php echo app('translator')->get('A5'); ?></option>
                                    <option type="button" value="a6"><?php echo app('translator')->get('A6'); ?></option>
                                    <option type="button" value="a7"><?php echo app('translator')->get('A7'); ?></option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label for="export-as"><?php echo app('translator')->get('Table Header Color'); ?></label>
                                <input type="color" name="heading_color" class="form-control" value="#4634ff">
                            </div>

                            <div class="mb-3 d-flex flex-wrap justify-content-between align-items-center">
                                <div>
                                    <label for="export-as"><?php echo app('translator')->get('Orientation'); ?></label>
                                    <div class="form-check">
                                        <input type="radio" name="orientation" value="portrait" class="form-check-input" id="portrait-orientation" checked>
                                        <label class="form-check-label" for="portrait-orientation">
                                            <?php echo app('translator')->get('Portrait'); ?>
                                        </label>
                                    </div>

                                    <div class="form-check">
                                        <input type="radio" name="orientation" value="landscape" class="form-check-input" id="landscape-orientation">
                                        <label class="form-check-label" for="landscape-orientation">
                                            <?php echo app('translator')->get('Landscape'); ?>
                                        </label>
                                    </div>

                                </div>
                                <div class="orientation-sample portrait"></div>
                            </div>

                            <div class="mb-3">
                                <label for="export-as"><?php echo app('translator')->get('Font Size'); ?></label>
                                <input type="range" name="font_size" min="6" max="30" step="1" value="12" class="form-range">
                                <div class="sample-text"></div>
                            </div>
                        </div>

                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Export'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/vendor/xlsx.full.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/jspdf.umd.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/jspdf.plugin.autotable.min.js')); ?> "></script>
    <script src="<?php echo e(asset('assets/admin/js/visertable.js')); ?>" type="module"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(`[name="visible_columns[]"]`).val(<?php echo json_encode($visibleColumns, 15, 512) ?>);
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .table-option-btn {
            padding: 8px 8px;
            margin: 0;
            background: transparent;
            border: 1px solid #ced4da;
            font-size: 14px;
            border-radius: 5px;
            color: #6c757d;
            line-height: 1;
            transition: all linear 0.3s;
        }

        .table-options input.form-control,
        .table-options select.form-control {
            height: 32px !important;
            border: 1px solid #ced4da !important;
            padding-inline: 12px;
            font-size: 14px;
            color: #6c757d;
        }

        .table-option-btn:hover {
            border-color: #4634ff;
        }

        .table-options select {
            font-size: 14px;
            padding: 8px 8px;
            line-height: 1;
            padding-right: 30px;
            width: max-content !important;
            color: #6c757d;
            background-position: right .5rem center;
            background-blend-mode: hard-light;
        }

        .table-options select:focus,
        .table-options input.form-control:focus {
            box-shadow: none;
            border-color: #4634ff !important;
        }

        .top-filter-title {
            font-size: 13px;
        }

        input[type="range"]:active,
        input[type="range"]:focus {
            box-shadow: none;
        }

        .orientation-sample.portrait {
            width: 40px;
            height: 65px;
            border: 1px solid #cecece;
        }

        .orientation-sample.landscape {
            height: 40px;
            width: 65px;
            border: 1px solid #cecece;
        }

        @media(max-width: 1199px){
            .table-options select{
                font-size: 12px;
                padding: 6px 6px;
                padding-right: 24px;
                background-position: right .3rem center;
            }

            .table-option-btn {
                padding: 6px 6px;
                font-size: 12px;
            }

            .table-options input.form-control, .table-options select.form-control {
                height: 30px !important;
                max-width: 140px;
            }
        }

    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/core/resources/views/components/viser_table/table-options.blade.php ENDPATH**/ ?>