<div class="row justify-content-center gy-4 gx-sm-3 gx-md-4">
    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-4 col-sm-6">
            <div class="plan-card rounded-3 wow fadeInUp">
                <div class="plan-card__header">
                    <div class="wave-shape">
                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/elements/wave.png')); ?>" alt="img">
                    </div>
                    <h4 class="plan-name"><?php echo e(__(@$plan->name)); ?></h4>
                    <div class="plan-price">
                        <?php echo e(gs()->cur_sym . getAmount(@$plan->per_installment)); ?>

                        <sub>/<?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?></sub>
                    </div>
                </div>
                <div class="plan-card__body text-center">
                    <ul class="plan-feature-list">
                        <li class="d-flex flex-wrap justify-content-between">
                            <span> <?php echo app('translator')->get('Interest Rate'); ?> </span>
                            <?php echo e(getAmount($plan->interest_rate)); ?>%
                        </li>

                        <li class="d-flex flex-wrap justify-content-between">
                            <span> <?php echo app('translator')->get('Per Installment'); ?> </span>
                            <?php echo e(showAmount($plan->per_installment)); ?>

                        </li>

                        <li class="d-flex flex-wrap justify-content-between">
                            <span> <?php echo app('translator')->get('Installment Interval'); ?></span>
                            <?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?>

                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('Total Installment'); ?></span>
                            <?php echo e(@$plan->total_installment); ?>

                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span> <?php echo app('translator')->get('Deposit'); ?></span>
                            <?php echo e(showAmount(@$plan->total_installment * @$plan->per_installment)); ?>

                        </li>
                        <li class="d-flex flex-wrap justify-content-between">
                            <span><?php echo app('translator')->get('You Will Get'); ?></span>
                            <?php echo e(showAmount($plan->final_amount)); ?>

                        </li>
                    </ul>
                </div>
                <div class="plan-card__footer text-center">
                    <button type="button" data-id="<?php echo e($plan->id); ?>" class="btn btn-md w-100 btn--base dpsBtn"><?php echo app('translator')->get('Apply Now'); ?></button>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            $('.dpsBtn').on('click', (e) => {
                let modal = $('#dpsModal');
                let data = e.currentTarget.dataset;
                let form = modal.find('form')[0];
                form.action = `<?php echo e(route('user.dps.apply', '')); ?>/${data.id}`;
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="dpsModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="" method="post">
                    <?php if(auth()->guard()->check()): ?>
                        <div class="modal-header">
                            <h5 class="modal-title method-name"><?php echo app('translator')->get('Apply to Open a DPS'); ?></h5>
                            <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <i class="las la-times"></i>
                            </span>
                        </div>

                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <?php if(checkIsOtpEnable()): ?>
                                <?php echo $__env->make($activeTemplate . 'partials.otp_field', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                            <?php else: ?>
                                <?php echo app('translator')->get('Are you sure to apply for this plan?'); ?>
                            <?php endif; ?>
                        </div>
                        <?php if(!checkIsOtpEnable()): ?>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-sm btn--dark" data-bs-dismiss="modal" aria-label="Close"><?php echo app('translator')->get('No'); ?></button>
                                <button type="submit" class="btn btn-sm btn--base h-auto"><?php echo app('translator')->get('Yes'); ?></button>
                            </div>
                        <?php endif; ?>
                    <?php else: ?>
                        <div class="modal-body">
                            <div class="text-center"><i class="la la-times-circle text--danger la-6x" aria-hidden="true"></i></div>
                            <h3 class="text-center mt-3"><?php echo app('translator')->get('You are not logged in!'); ?></h3>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn btn-sm btn--dark" data-bs-dismiss="modal" aria-label="Close"><?php echo app('translator')->get('Close'); ?></button>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/partials/dps_plans.blade.php ENDPATH**/ ?>