<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-lg-8">

            <?php if($user->kv == Status::KYC_PENDING): ?>
                <div class="card custom--card  mb-4">
                    <div class="card-body">
                        <h5 class="mb-2 text--success">
                            <?php echo app('translator')->get('Thank You for Submitting Your KYC Information!'); ?>
                        </h5>
                        <p class="text-muted">
                            <?php echo app('translator')->get('We appreciate your cooperation in completing the KYC process. Your information has been successfully submitted and is now under review.'); ?>
                        </p>
                    </div>
                </div>
            <?php elseif($user->kv == Status::KYC_UNVERIFIED && $user->kyc_rejection_reason): ?>
                <div class="card custom--card  mb-4">
                    <div class="card-body">
                        <h5 class="mb-2 text--danger">
                            <?php echo app('translator')->get('KYC Rejection Notice!'); ?>
                        </h5>
                        <p class="text-muted mb-2">
                            <?php echo e($user->kyc_rejection_reason); ?>

                        </p>

                        <?php echo e(__(@$kyc->data_values->reject)); ?> <a href="<?php echo e(route('user.kyc.form')); ?>"><?php echo app('translator')->get('Click Here to Re-submit KYC Your Information'); ?>.</a></p>
                    </div>
                </div>
            <?php endif; ?>

            <div class="card custom--card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <?php echo app('translator')->get('KYC Information'); ?>
                    </h5>
                    <?php if($user->kv == Status::VERIFIED): ?>
                        <span class="badge badge--success"><?php echo app('translator')->get('Approved'); ?></span>
                    <?php endif; ?>
                </div>
                <div class="card-body">

                    <?php if($user->kyc_data): ?>
                        <ul class="list-group list-group-flush">
                            <?php $__currentLoopData = $user->kyc_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!$val->value) continue; ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center py-3">
                                    <?php echo e(__($val->name)); ?>

                                    <span>
                                        <?php if($val->type == 'checkbox'): ?>
                                            <?php echo e(implode(',', $val->value)); ?>

                                        <?php elseif($val->type == 'file'): ?>
                                            <a href="<?php echo e(route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $val->value))); ?>" class="ms-3"><i class="fa fa-file"></i> <?php echo app('translator')->get('View File'); ?> </a>
                                        <?php else: ?>
                                            <p><?php echo e(__($val->value)); ?></p>
                                        <?php endif; ?>
                                    </span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <h5 class="text-center"><?php echo app('translator')->get('KYC data not found'); ?></h5>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/kyc/info.blade.php ENDPATH**/ ?>