<?php
    $content = getContent('partner_section.content', true);
    $elements = getContent('partner_section.element');
?>

<?php if($content): ?>

    <section class="pt-100 pb-100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6 text-center">
                    <div class="section-header">
                        <h2 class="section-title"><?php echo e(__($content->data_values->heading)); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <div class="col-lg-12">
                    <div class="brand-slider">
                        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-slide">
                                <div class="brand-item">
                                    <img src="<?php echo e(getImage('assets/images/frontend/partner_section/' . @$element->data_values->image, '300x300')); ?>" alt="image">
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php if(!app()->offsetExists('slick_asset')): ?>
    <?php $__env->startPush('style-lib'); ?>
        <link href="<?php echo e(asset('assets/global/css/slick.css')); ?>" rel="stylesheet">
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/slick.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>

    <?php app()->offsetSet('slick_asset',true) ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.brand-slider').slick({
                autoplay: true,
                autoplaySpeed: 2000,
                dots: false,
                infinite: true,
                speed: 300,
                slidesToShow: 8,
                arrows: false,
                slidesToScroll: 1,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 7,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 5,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 4,
                        }
                    },
                    {
                        breakpoint: 576,
                        settings: {
                            slidesToShow: 3,
                        }
                    }
                ]
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/sections/partner_section.blade.php ENDPATH**/ ?>