<?php $__env->startSection('panel'); ?>
    <div class="row gy-4">
        <div class="col-xl-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Current Fund'); ?></h5>

                    <div class="row g-0">
                        <div class="col-xl-3 col-sm-6">
                            <div class="p-3 border h-100">
                                <small class="text-muted"><?php echo app('translator')->get('Users Wallet'); ?></small>
                                <h6><?php echo e(gs('cur_sym') . showAmount($funds['balance'], currencyFormat: false)); ?></h6>
                            </div>
                        </div>

                        <div class="col-xl-3 col-sm-6">
                            <div class="p-3 border h-100 ">
                                <small class="text-muted"><?php echo app('translator')->get('On Account of FDR'); ?></small>
                                <h6><?php echo e(gs('cur_sym') . showAmount($funds['dps'], currencyFormat: false)); ?></h6>
                            </div>
                        </div>

                        <div class="col-xl-3 col-sm-6">
                            <div class="p-3 border h-100">
                                <small class="text-muted"><?php echo app('translator')->get('On Account of DPS'); ?></small>
                                <h6><?php echo e(gs('cur_sym') . showAmount($funds['dps'], currencyFormat: false)); ?></h6>
                            </div>
                        </div>

                        <div class="col-xl-3 col-sm-6">
                            <div class="p-3 border h-100 ">
                                <small class="text-muted"><?php echo app('translator')->get('Total In Fund'); ?></small>
                                <h5><?php echo e(gs('cur_sym') . showAmount(array_sum($funds), currencyFormat: false)); ?></h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap justify-content-between">
                        <h5 class="card-title"><?php echo app('translator')->get('Deposit & Withdraw Report'); ?></h5>

                        <div id="dwDatePicker" class="border p-1 cursor-pointer rounded">
                            <i class="la la-calendar"></i>&nbsp;
                            <span></span> <i class="la la-caret-down"></i>
                        </div>
                    </div>

                    <div id="dwChartArea"> </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap justify-content-between">
                        <h5 class="card-title"><?php echo app('translator')->get('Transactions Report'); ?></h5>

                        <div id="trxDatePicker" class="border p-1 cursor-pointer rounded">
                            <i class="la la-calendar"></i>&nbsp;
                            <span></span> <i class="la la-caret-down"></i>
                        </div>
                    </div>

                    <div id="transactionChartArea"></div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-sm-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Pending'); ?></h5>
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('Deposit Requests'); ?></span>
                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.deposit.pending')): ?><?php echo e(route('admin.deposit.pending')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['total_deposit_pending']): ?> bg--warning text--black <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['total_deposit_pending']); ?>

                                </span>
                            </a>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('Withdrawal Requests'); ?></span>

                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.withdraw.data.pending')): ?><?php echo e(route('admin.withdraw.data.pending')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['total_withdraw_pending']): ?> bg-warning  text-black <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['total_withdraw_pending']); ?>

                                </span>
                            </a>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('Loan Applications'); ?></span>

                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.loan.pending')): ?><?php echo e(route('admin.loan.pending')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['total_pending_loan']): ?> bg--danger text-white <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['total_pending_loan']); ?>

                                </span>
                            </a>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('Supprt Tickets'); ?></span>

                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.ticket.pending')): ?><?php echo e(route('admin.ticket.pending')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['pending_tickets']): ?> bg--10 text-white <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['pending_tickets']); ?>

                                </span>
                            </a>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('KYC Verifications'); ?></span>

                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.users.kyc.pending')): ?><?php echo e(route('admin.users.kyc.pending')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="badge <?php if($widget['kyc_pending_users']): ?> bg--5 text-white fw-bold <?php else: ?> bg--1 text--white <?php endif; ?>">
                                    <?php echo e($widget['kyc_pending_users']); ?>

                                </span>
                            </a>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('Money Transfers'); ?></span>
                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.transfers.pending')): ?><?php echo e(route('admin.transfers.pending')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="badge fw-bold <?php if($widget['pending_transfers']): ?> bg--6 text--black  <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['pending_transfers']); ?>

                                </span>
                            </a>
                        </li>
                    </ul>

                </div>
            </div>

            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title "><?php echo app('translator')->get('Installment Due'); ?></h5>

                    <ul class="list-group list-group-flush">

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('FDR'); ?></span>


                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.fdr.due')): ?><?php echo e(route('admin.fdr.due')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['total_due_fdr']): ?> bg--warning text--black <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['total_due_fdr']); ?>

                                </span>
                            </a>

                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('DPS'); ?></span>

                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.dps.due')): ?><?php echo e(route('admin.dps.due')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['total_due_dps']): ?> bg-warning text--black <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['total_due_dps']); ?>

                                </span>
                            </a>
                        </li>

                        <li class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <span><?php echo app('translator')->get('Loan'); ?></span>

                            <a href="<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.loan.due')): ?><?php echo e(route('admin.loan.due')); ?><?php else: ?> # <?php endif; ?>">
                                <span class="fw-bold badge <?php if($widget['total_due_loan']): ?> bg--danger <?php else: ?> bg--success text-white <?php endif; ?>">
                                    <?php echo e($widget['total_due_loan']); ?>

                                </span>
                            </a>
                        </li>

                    </ul>

                </div>
            </div>
        </div>

        <div class="col-xxl-3 col-sm-6">

            <div class="card">

                <div class="card-body">
                    <h5 class="card-title mb-3"><?php echo app('translator')->get('Ongoing'); ?></h5>
                    <div class="row gy-3 ongoing-widget">

                        <div class="col-12">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['total_running_fdr']).'','title' => 'Running FDR','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'amber','icon' => 'las la-store','link' => 'admin.fdr.running','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['total_running_fdr']).'','title' => 'Running FDR','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'amber','icon' => 'las la-store','link' => 'admin.fdr.running','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-12">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['total_running_dps']).'','title' => 'Running DPS','boxShadow' => false,'style' => '2','bg' => 'white','color' => '7','icon' => 'las la-coins','link' => 'admin.dps.running','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['total_running_dps']).'','title' => 'Running DPS','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => '7','icon' => 'las la-coins','link' => 'admin.dps.running','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-12">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['total_matured_dps']).'','title' => 'Matured DPS','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'warning','icon' => 'las la-coins','link' => 'admin.dps.matured','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['total_matured_dps']).'','title' => 'Matured DPS','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'warning','icon' => 'las la-coins','link' => 'admin.dps.matured','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-12">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['total_running_loan']).'','title' => 'Running Loan','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'indigo','icon' => 'las la-hand-holding-usd','link' => 'admin.loan.running','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['total_running_loan']).'','title' => 'Running Loan','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'indigo','icon' => 'las la-hand-holding-usd','link' => 'admin.loan.running','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>

        </div>

        <div class="col-xxl-6 col-xl-7 col-lg-8">
            <div class="card">

                <div class="card-body">
                    <h5 class="card-title mb-3"><?php echo app('translator')->get('Accounts'); ?></h5>

                    <div class="row g-3 account-widget">

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['total_users']).'','title' => 'Total Registered','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'info','icon' => 'la la-users','link' => 'admin.users.all','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['total_users']).'','title' => 'Total Registered','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'info','icon' => 'la la-users','link' => 'admin.users.all','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['profile_completed']).'','title' => 'Profile Completed','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'success','icon' => 'la la-user-check','link' => 'admin.users.profile.completed','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['profile_completed']).'','title' => 'Profile Completed','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'success','icon' => 'la la-user-check','link' => 'admin.users.profile.completed','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['active_users']).'','title' => 'Active','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'green','icon' => 'la la-user-check','link' => 'admin.users.active','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['active_users']).'','title' => 'Active','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'green','icon' => 'la la-user-check','link' => 'admin.users.active','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['banned_users']).'','title' => 'Banned','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'danger','icon' => 'la la-user-slash','link' => 'admin.users.banned','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['banned_users']).'','title' => 'Banned','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'danger','icon' => 'la la-user-slash','link' => 'admin.users.banned','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['email_unverified_users']).'','title' => 'Email Unverified','boxShadow' => false,'style' => '2','bg' => 'white','color' => '5','icon' => 'la la-envelope','link' => 'admin.users.email.unverified','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['email_unverified_users']).'','title' => 'Email Unverified','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => '5','icon' => 'la la-envelope','link' => 'admin.users.email.unverified','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['mobile_unverified_users']).'','title' => 'Mobile Unverified','boxShadow' => false,'style' => '2','bg' => 'white','color' => '2','icon' => 'la la-mobile','link' => 'admin.users.mobile.unverified','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['mobile_unverified_users']).'','title' => 'Mobile Unverified','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => '2','icon' => 'la la-mobile','link' => 'admin.users.mobile.unverified','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['kyc_unverified_users']).'','title' => 'KYC Unverified','boxShadow' => false,'style' => '2','bg' => 'white','color' => '3','icon' => 'la la-user-slash','link' => 'admin.users.mobile.unverified','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['kyc_unverified_users']).'','title' => 'KYC Unverified','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => '3','icon' => 'la la-user-slash','link' => 'admin.users.mobile.unverified','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                        <div class="col-sm-6">
                            <?php if (isset($component)) { $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.widget','data' => ['value' => ''.e($widget['kyc_pending_users']).'','title' => 'KYC Pending','boxShadow' => false,'style' => '2','bg' => 'white','color' => 'warning','icon' => 'la la-user','link' => 'admin.users.mobile.unverified','iconStyle' => 'solid','overlayIcon' => '0']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('widget'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['value' => ''.e($widget['kyc_pending_users']).'','title' => 'KYC Pending','box_shadow' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false),'style' => '2','bg' => 'white','color' => 'warning','icon' => 'la la-user','link' => 'admin.users.mobile.unverified','icon_style' => 'solid','overlay_icon' => '0']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $attributes = $__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__attributesOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9)): ?>
<?php $component = $__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9; ?>
<?php unset($__componentOriginal433d6a5be5b58ac8aa6a74031c6196f9); ?>
<?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>

    <div class="row gy-4 mt-3">
        <div class="col-xl-4 col-lg-6">
            <div class="card overflow-hidden">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Login By Browser'); ?> (<?php echo app('translator')->get('Last 30 days'); ?>)</h5>
                    <canvas id="userBrowserChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Login By OS'); ?> (<?php echo app('translator')->get('Last 30 days'); ?>)</h5>
                    <canvas id="userOsChart"></canvas>
                </div>
            </div>
        </div>
        <div class="col-xl-4 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title"><?php echo app('translator')->get('Login By Country'); ?> (<?php echo app('translator')->get('Last 30 days'); ?>)</h5>
                    <canvas id="userCountryChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <?php if(auth()->guard('admin')->id() == 1): ?>
        <?php echo $__env->make('admin.partials.cron_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .apexcharts-menu {
            min-width: 120px !important;
        }

        .card .list-group-item {
            padding: .57rem 1rem;
        }
        .account-widget .widget-two, .ongoing-widget .widget-two{
            border: 1px solid #eee !important;
        }
        .list-group-item {
            border-color: #eee !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/vendor/apexcharts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/vendor/chart.js.2.8.0.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/daterangepicker.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/charts.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/admin/css/daterangepicker.css')); ?>" />
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        const start = moment().subtract(14, 'days');
        const end = moment();

        const dateRangeOptions = {
            startDate: start,
            endDate: end,
            ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 15 Days': [moment().subtract(14, 'days'), moment()],
                'Last 30 Days': [moment().subtract(30, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'Last 6 Months': [moment().subtract(6, 'months').startOf('month'), moment().endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
            }
        }

        const changeDatePickerText = (element, startDate, endDate) => {
            $(element).html(startDate.format('MMMM D, YYYY') + ' - ' + endDate.format('MMMM D, YYYY'));
        }

        let dwChart = barChart(
            document.querySelector("#dwChartArea"),
            <?php echo json_encode(__(gs('cur_text')), 15, 512) ?>,
            [{
                    name: 'Deposited',
                    data: []
                },
                {
                    name: 'Withdrawn',
                    data: []
                }
            ],
            [],
        );

        let trxChart = lineChart(
            document.querySelector("#transactionChartArea"),
            [{
                    name: "Plus Transactions",
                    data: []
                },
                {
                    name: "Minus Transactions",
                    data: []
                }
            ],
            []
        );


        const depositWithdrawChart = (startDate, endDate) => {

            const data = {
                start_date: startDate.format('YYYY-MM-DD'),
                end_date: endDate.format('YYYY-MM-DD')
            }

            const url = <?php echo json_encode(route('admin.chart.deposit.withdraw'), 15, 512) ?>;

            $.get(url, data,
                function(data, status) {
                    if (status == 'success') {
                        dwChart.updateSeries(data.data);
                        dwChart.updateOptions({
                            xaxis: {
                                categories: data.created_on,
                            }
                        });
                    }
                }
            );
        }

        const transactionChart = (startDate, endDate) => {

            const data = {
                start_date: startDate.format('YYYY-MM-DD'),
                end_date: endDate.format('YYYY-MM-DD')
            }

            const url = <?php echo json_encode(route('admin.chart.transaction'), 15, 512) ?>;


            $.get(url, data,
                function(data, status) {
                    if (status == 'success') {


                        trxChart.updateSeries(data.data);
                        trxChart.updateOptions({
                            xaxis: {
                                categories: data.created_on,
                            }
                        });
                    }
                }
            );
        }



        $('#dwDatePicker').daterangepicker(dateRangeOptions, (start, end) => changeDatePickerText('#dwDatePicker span', start, end));
        $('#trxDatePicker').daterangepicker(dateRangeOptions, (start, end) => changeDatePickerText('#trxDatePicker span', start, end));

        changeDatePickerText('#dwDatePicker span', start, end);
        changeDatePickerText('#trxDatePicker span', start, end);

        depositWithdrawChart(start, end);
        transactionChart(start, end);

        $('#dwDatePicker').on('apply.daterangepicker', (event, picker) => depositWithdrawChart(picker.startDate, picker.endDate));
        $('#trxDatePicker').on('apply.daterangepicker', (event, picker) => transactionChart(picker.startDate, picker.endDate));

        piChart(
            document.getElementById('userBrowserChart'),
            <?php echo json_encode(@$chartData['user_browser_counter']->keys(), 15, 512) ?>,
            <?php echo json_encode(@$chartData['user_browser_counter']->flatten(), 15, 512) ?>
        );

        piChart(
            document.getElementById('userOsChart'),
            <?php echo json_encode(@$chartData['user_os_counter']->keys(), 15, 512) ?>,
            <?php echo json_encode(@$chartData['user_os_counter']->flatten(), 15, 512) ?>
        );

        piChart(
            document.getElementById('userCountryChart'),
            <?php echo json_encode(@$chartData['user_country_counter']->keys(), 15, 512) ?>,
            <?php echo json_encode(@$chartData['user_country_counter']->flatten(), 15, 512) ?>
        );
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>