<?php $__env->startSection('content'); ?>
    <?php if(gs()->modules->other_bank): ?>
        <div class="d-flex flex-wrap justify-content-end mb-3">
            <a class="btn btn-sm btn--dark" href="<?php echo e(route('user.beneficiary.other')); ?>"> <i class="la la-users"></i> <?php echo app('translator')->get('Manage Beneficiaries'); ?></a>
        </div>
    <?php endif; ?>

    <div class="table-responsive--md">
        <table class="custom--table table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Name'); ?></th>
                    <th><?php echo app('translator')->get('Account Name'); ?></th>
                    <th><?php echo app('translator')->get('Account Number'); ?></th>
                    <th><?php echo app('translator')->get('Bank'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $bank = $beneficiary->beneficiaryOf;
                    ?>
                    <tr>
                        <td><?php echo e($beneficiary->short_name); ?></td>
                        <td><?php echo e($beneficiary->account_name); ?></td>
                        <td><?php echo e($beneficiary->account_number); ?></td>
                        <td><?php echo e($bank->name); ?></td>
                        <td>
                            <span title="<?php echo app('translator')->get('Details'); ?>">
                                <button class="btn btn-sm btn-outline--base seeDetails" data-id="<?php echo e($beneficiary->id); ?>"><i class="la la-desktop"></i> <?php echo app('translator')->get('Details'); ?></button>
                            </span>
                            <span title="<?php echo app('translator')->get('Transfer Money'); ?>">
                                <button class="btn btn-sm btn-outline--success sendBtn" data-name="<?php echo e($beneficiary->short_name); ?>" data-processing_time="<?php echo e($bank->processing_time); ?>" data-transfer_charge="<?php echo e($bank->charge_text); ?>" data-bank_name="<?php echo e($bank->name); ?>" data-id="<?php echo e($beneficiary->id); ?>" data-minimum_amount="<?php echo e(showAmount($bank->minimum_limit)); ?>" data-maximum_amount="<?php echo e(showAmount($bank->maximum_limit)); ?>" data-daily_limit="<?php echo e(showAmount($bank->daily_maximum_limit)); ?>" data-monthly_limit="<?php echo e(showAmount($bank->monthly_maximum_limit)); ?>" data-daily_count="<?php echo e($bank->daily_total_transaction); ?>" data-monthly_count="<?php echo e($bank->monthly_total_transaction); ?>" type="button">
                                    <i class="las la-hand-holding-usd"></i> <?php echo app('translator')->get('Transfer'); ?>
                                </button>
                            </span>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="text-center" colspan="100%"><?php echo app('translator')->get($emptyMessage); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    <?php if($beneficiaries->hasPages()): ?>
        <div class="mt-3">
            <?php echo e(paginateLinks($beneficiaries)); ?>

        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('.sendBtn').on('click', function() {
                let modal = $('#sendModal');
                let data = $(this).data();
                modal.find('.minimum_amount').text(data.minimum_amount);
                modal.find('.maximum_amount').text(data.maximum_amount);
                modal.find('.daily_limit').text(data.daily_limit);
                modal.find('.monthly_limit').text(data.monthly_limit);
                modal.find('.daily_count').text(data.daily_count);
                modal.find('.monthly_count').text(data.monthly_count);
                modal.find('.bank-name').val(data.bank_name);
                modal.find('.short-name').val(data.name);
                modal.find('.processing_time').text(data.processing_time);
                if (data.transfer_charge) {
                    modal.find('.transfer_charge').html(`<small class="text--danger">* <?php echo app('translator')->get('Charge'); ?>: ${data.transfer_charge}</small>`);
                }
                modal.find('form')[0].action = `<?php echo e(route('user.transfer.other.bank.request', '')); ?>/${data.id}`;
                modal.modal('show');
            });

            $('.seeDetails').on('click', function() {
                let modal = $('#detailsModal');
                modal.find('.loading').removeClass('d-none');
                let action = `<?php echo e(route('user.beneficiary.details', ':id')); ?>`;
                let id = $(this).attr('data-id');
                $.ajax({
                    url: action.replace(':id', id),
                    type: "GET",
                    dataType: 'json',
                    cache: false,
                    success: function(response) {
                        if (response.success) {
                            modal.find('.loading').addClass('d-none');
                            modal.find('.modal-body').html(response.html);
                            modal.modal('show');
                        } else {
                            notify('error', response.message || `<?php echo app('translator')->get('Something went the wrong'); ?>`)
                        }
                    },
                    error: function(e) {
                        notify(`<?php echo app('translator')->get('Something went the wrong'); ?>`)
                    }
                });
            });

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('modal'); ?>
    <!-- Details Modal -->
    <div class="modal fade" id="detailsModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Benficiary Details'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <?php if (isset($component)) { $__componentOriginal8c1c796af10563291be3a19176d03808 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8c1c796af10563291be3a19176d03808 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ajax-loader','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('ajax-loader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8c1c796af10563291be3a19176d03808)): ?>
<?php $attributes = $__attributesOriginal8c1c796af10563291be3a19176d03808; ?>
<?php unset($__attributesOriginal8c1c796af10563291be3a19176d03808); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8c1c796af10563291be3a19176d03808)): ?>
<?php $component = $__componentOriginal8c1c796af10563291be3a19176d03808; ?>
<?php unset($__componentOriginal8c1c796af10563291be3a19176d03808); ?>
<?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="sendModal">
        <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Transfer Money'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row gx-5">
                            <div class="col-xl-5 mb-3">

                                <h6 class="mb-2 text-center"><?php echo app('translator')->get('Transfer Limit'); ?></h6>
                                <ul class="caption-list-two my-3 p-0">
                                    <li>
                                        <span class="caption"><?php echo app('translator')->get('Minimum Per Transaction'); ?></span>
                                        <span class="value minimum_amount"></span>
                                    </li>
                                    <li>
                                        <span class="caption"><?php echo app('translator')->get('Maximum Per Transaction'); ?></span>
                                        <span class="value maximum_amount"></span>
                                    </li>
                                    <li>
                                        <span class="caption"><?php echo app('translator')->get('Daily Maximum'); ?></span>
                                        <span class="value daily_limit"></span>
                                    </li>
                                    <li>
                                        <span class="caption"><?php echo app('translator')->get('Monthly Maximum'); ?></span>
                                        <span class="value monthly_limit"></span>
                                    </li>
                                    <li>
                                        <span class="caption"><?php echo app('translator')->get('Daily Maximum Transaction'); ?></span>
                                        <span class="value daily_count"></span>
                                    </li>
                                    <li>
                                        <span class="caption"> <?php echo app('translator')->get('Monthly Maximum Transaction'); ?></span>
                                        <span class="value monthly_count"></span>
                                    </li>
                                </ul>

                                <small class="text--danger">* <?php echo app('translator')->get('Processing Time'); ?>: <span class="processing_time"></span></small>
                                <div class="transfer_charge"></div>

                            </div>

                            <div class="col-xl-7">

                                <div class="form-group">
                                    <label class="required fw-bold"><?php echo app('translator')->get('Bank'); ?></label>
                                    <input class="bank-name form--control" class="form--control" type="text" readonly>
                                </div>
                                <div class="form-group">
                                    <label class="required fw-bold"><?php echo app('translator')->get('Recipient'); ?></label>
                                    <input class="short-name form--control" class="form--control" type="text" readonly>
                                </div>

                                <div class="form-group">
                                    <div class="d-flex justify-content-between flex-wrap gap-2">
                                        <label class="required fw-bold"><?php echo app('translator')->get('Amount'); ?></label>
                                        <span class="fw-bold"><?php echo app('translator')->get('Current Balance'); ?>: <?php echo e(showAmount(auth()->user()->balance)); ?></span>
                                    </div>

                                    <div class="input-group">
                                        <input class="form--control" name="amount" type="number" step="any" placeholder="<?php echo app('translator')->get('Enter an Amount'); ?>" required>
                                        <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                    </div>
                                </div>
                                <?php echo $__env->make($activeTemplate . 'partials.otp_field', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <button class="btn w-100 btn--base" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php if (isset($component)) { $__componentOriginalfaab69ae368581dbfbc77a98d132296d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfaab69ae368581dbfbc77a98d132296d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transfer-bottom-menu','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transfer-bottom-menu'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfaab69ae368581dbfbc77a98d132296d)): ?>
<?php $attributes = $__attributesOriginalfaab69ae368581dbfbc77a98d132296d; ?>
<?php unset($__attributesOriginalfaab69ae368581dbfbc77a98d132296d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfaab69ae368581dbfbc77a98d132296d)): ?>
<?php $component = $__componentOriginalfaab69ae368581dbfbc77a98d132296d; ?>
<?php unset($__componentOriginalfaab69ae368581dbfbc77a98d132296d); ?>
<?php endif; ?>

<?php $__env->startPush('style'); ?>
    <style>
        hr {
            height: 1px;
            background-color: #dee2e6;
            opacity: 0.8;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/transfer/other_bank/beneficiaries.blade.php ENDPATH**/ ?>