<?php $__env->startSection('panel'); ?>

    <?php
        $request = request();
        $tableName = 'transfers_list';
        $otherBanks = App\Models\OtherBank::get()->pluck('name')->toArray();
        $tableConfiguration = $tableConfiguration = tableConfiguration($tableName);

        $otherBanks[] = gs('site_name');
        $otherBanks[] = 'Wire Transfer';

        sort($otherBanks);

        $columns = collect([
            prepareTableColumn('trx', 'TRX No.'),
            prepareTableColumn('sender', 'Sender', link:'route("admin.users.detail", $item->user_id)'),
            prepareTableColumn('receiver', 'Receiver'),
            prepareTableColumn('receiver_bank', 'Receiver Bank', filter:'select', filterOptions:$otherBanks),
            prepareTableColumn('amount', 'Amount', 'showAmount("$item->amount")', filter: 'range'),
            prepareTableColumn('charge', 'Charge', 'showAmount("$item->charge")', filter: 'range'),
            prepareTableColumn('final_amount', 'Final Amount', 'showAmount("$item->final_amount")', filter: 'range'),
            prepareTableColumn('created_at', 'Created At', filter: 'date'),
            prepareTableColumn('status', 'Status', '$item->status_badge', echoable:true)
        ]);

        $action = [
            'name' => 'Action',
            'style' => '',

            'show' => can('admin.transfers.details'),
            'buttons' => [
                [
                    'name' => 'Details',
                    'link' => 'route("admin.transfers.details", $item->id)',
                    'show' => can('admin.transfers.details'),
                    'class' => 'btn-outline--primary',
                    'icon' => 'la la-desktop',

                ],
            ]
        ];


        if ($tableConfiguration) {
            $visibleColumns = $tableConfiguration->visible_columns;
        } else {
            $visibleColumns = $columns->pluck('id')->toArray();
        }
    ?>

    <?php if (isset($component)) { $__componentOriginala9d13211d16a9b68016cb700b31e0809 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala9d13211d16a9b68016cb700b31e0809 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table','data' => ['data' => $transfers,'columns' => $columns,'action' => $action,'columnConfig' => true,'tableName' => $tableName,'visibleColumns' => $visibleColumns,'class' => 'table-responsive--md table-responsive','searchPlaceholder' => 'Trx / Sender / Receiver']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($transfers),'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($columns),'action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($action),'columnConfig' => true,'tableName' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableName),'visibleColumns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($visibleColumns),'class' => 'table-responsive--md table-responsive','searchPlaceholder' => 'Trx / Sender / Receiver']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $attributes = $__attributesOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__attributesOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $component = $__componentOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__componentOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/transfers/index.blade.php ENDPATH**/ ?>