<header class="header">
    <div class="header__bottom">
        <div class="container">
            <nav class="navbar navbar-expand-lg flex-wrap align-items-center justify-content-between p-0">
                <a class="site-logo site-title" href="<?php echo e(route('home')); ?>">
                    <img src="<?php echo e(siteLogo()); ?>" alt="logo">
                </a>
                <button class="navbar-toggler" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" type="button" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="menu-toggle"></span>
                </button>
                <div class="collapse navbar-collapse mt-lg-0 mt-3" id="navbarSupportedContent">

                    <ul class="navbar-nav main-menu m-auto" id="linkItem">
                        <?php if(auth()->user() && request()->routeIs('ticket*')): ?>
                            <?php echo $__env->make($activeTemplate . 'partials.auth_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php elseif(!request()->routeIs('user.*') || !auth()->user()): ?>
                            <?php echo $__env->make($activeTemplate . 'partials.guest_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php else: ?>
                            <?php echo $__env->make($activeTemplate . 'partials.auth_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                    </ul>

                    <?php if(!(Route::is('user.*') && auth()->user())): ?>
                        <div class="nav-right">
                            <?php if(gs('multi_language')): ?>

                                <?php
                                    $language = App\Models\Language::all();
                                    $selectLang = $language->where('code', config('app.locale'))->first();
                                    $currentLang = session('lang') ? $language->where('code', session('lang'))->first() : $language->where('is_default', Status::YES)->first();
                                ?>
                                <?php if($language->count()): ?>
                                    <div class="language_switcher me-3">
                                        <div class="language_switcher__caption">
                                            <span class="icon">
                                                <img src="<?php echo e(getImage(getFilePath('language') . '/' . @$currentLang->image, getFileSize('language'))); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                            </span>
                                            <span class="text"> <?php echo e(__(@$selectLang->name)); ?> </span>
                                        </div>
                                        <div class="language_switcher__list">
                                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="language_switcher__item    <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>" data-value="<?php echo e($item->code); ?>">
                                                    <a href="<?php echo e(route('lang', $item->code)); ?>" class="thumb">
                                                        <span class="icon">
                                                            <img src="<?php echo e(getImage(getFilePath('language') . '/' . $item->image, getFileSize('language'))); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                                        </span>
                                                        <span class="text"> <?php echo e(__($item->name)); ?></span>
                                                    </a>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php if(auth()->user() && !request()->routeIs('user.*')): ?>
                                <a class="btn btn-sm header-base-button me-3 py-2" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                            <?php endif; ?>

                            <?php if(auth()->guard()->guest()): ?>
                                <a class="btn btn-sm header-base-button me-3 py-2" href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Sign In'); ?></a>
                                <?php if(gs('registration')): ?>
                                    <a class="btn btn-sm btn--base py-2 text-white" href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Sign Up'); ?></a>
                                <?php endif; ?>
                            <?php else: ?>
                                <a class="btn btn-sm btn--base py-2 text-white logout-btn" href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a>
                            <?php endif; ?>
                        </div>
                    <?php else: ?>
                        <div class="nav-right">
                            <a class="btn btn-sm btn--base py-2 text-white logout-btn" href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a>
                        </div>
                    <?php endif; ?>
                </div>

            </nav>
        </div>
    </div>
</header>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/partials/header.blade.php ENDPATH**/ ?>