<?php
    $user = auth()->user();
    $image = getImage(getFilePath('userProfile') . '/' . $user->image, null, true);
    $hour = now()->hour;

    if ($hour >= 5 && $hour < 12) {
        $greeting = 'Good Morning';
    } elseif ($hour >= 12 && $hour < 18) {
        $greeting = 'Good Afternoon';
    } else {
        $greeting = 'Good Evening';
    }
?>

<?php $__env->startSection('content'); ?>
<div class="container">
    
    <div class="card bg--dark p-4 text-white rounded-3 mb-4">
        <div class="d-flex align-items-center gap-3">
            <img src="<?php echo e($image); ?>" alt="User Image" class="rounded-circle" width="60" height="60">
            <div>
                <h5 class="mb-1 text-white"><?php echo e($greeting); ?>, <?php echo e($user->firstname); ?></h5>
                <h2 class="text-white"><?php echo e(showAmount($user->balance, 2, '.', '')); ?></h2>
            </div>
            <div class="ms-auto">
                <a href="<?php echo e(route('user.deposit.index')); ?>" class="btn btn--base rounded-circle">
                    <i class="las la-plus"></i>
                </a>
            </div>
        </div>
        <div class="mt-3">
            <p class="text-white mb-1 small">Acc Number: <?php echo e($user->account_number); ?></p>
            <p class="text-white small">Last login: <?php echo e(showDateTime($user->last_login)); ?> | IP: <?php echo e($user->last_login_ip); ?></p>
        </div>
    </div>

    
    <div class="row g-3 text-center">
        <?php if(gs()->modules->deposit): ?>
            <div class="col-4">
                <a href="<?php echo e(route('user.deposit.index')); ?>" class="card p-3 bg-white text-dark rounded">
                    <i class="las la-wallet fs-2"></i>
                    <p class="mt-2">Deposit</p>
                </a>
            </div>
        <?php endif; ?>

        <?php if(gs()->modules->withdraw): ?>
            <div class="col-4">
                <a href="<?php echo e(route('user.withdraw.history')); ?>" class="card p-3 bg-white text-dark rounded">
                    <i class="las la-money-bill fs-2"></i>
                    <p class="mt-2">Withdraw</p>
                </a>
            </div>
        <?php endif; ?>

        <?php if(gs()->modules->loan): ?>
            <div class="col-4">
                <a href="<?php echo e(route('user.loan.list')); ?>" class="card p-3 bg-white text-dark rounded">
                    <i class="las la-hand-holding-usd fs-2"></i>
                    <p class="mt-2">Loan</p>
                </a>
            </div>
        <?php endif; ?>

        <?php if(gs()->modules->dps): ?>
            <div class="col-4">
                <a href="<?php echo e(route('user.dps.list')); ?>" class="card p-3 bg-white text-dark rounded">
                    <i class="las la-box fs-2"></i>
                    <p class="mt-2">DPS</p>
                </a>
            </div>
        <?php endif; ?>

        <?php if(gs()->modules->fdr): ?>
            <div class="col-4">
                <a href="<?php echo e(route('user.fdr.list')); ?>" class="card p-3 bg-white text-dark rounded">
                    <i class="las la-piggy-bank fs-2"></i>
                    <p class="mt-2">FDR</p>
                </a>
            </div>
        <?php endif; ?>

        <?php if(gs()->modules->own_bank || gs()->modules->other_bank || gs()->modules->wire_transfer): ?>
            <div class="col-4">
                <a href="<?php echo e(route('user.transfer.history')); ?>" class="card p-3 bg-white text-dark rounded">
                    <i class="las la-exchange-alt fs-2"></i>
                    <p class="mt-2">Transfer</p>
                </a>
            </div>
        <?php endif; ?>
    </div>

    
    <div class="row mt-4">
        <div class="col-md-6">
            <h5 class="text-white bg--dark p-2 rounded mb-2">Latest Credits</h5>
            <div class="card p-2" style="background-color: #1d1d2d;">
                <table class="table table-dark table-striped mb-0">
                    <thead>
                        <tr>
                            <th>TRX</th>
                            <th>Amount</th>
                            <th>Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $credits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>#<?php echo e($credit->trx); ?></td>
                                <td><?php echo e(showAmount($credit->amount)); ?></td>
                                <td><?php echo e(showDateTime($credit->created_at, 'd M, Y h:i A')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center text-white">No Credit Transactions</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="col-md-6">
            <h5 class="text-white bg--dark p-2 rounded mb-2">Latest Debits</h5>
            <div class="card p-2" style="background-color: #1d1d2d;">
                <table class="table table-dark table-striped mb-0">
                    <thead>
                        <tr>
                            <th>TRX</th>
                            <th>Amount</th>
                            <th>Time</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $debits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $debit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>#<?php echo e($debit->trx); ?></td>
                                <td><?php echo e(showAmount($debit->amount)); ?></td>
                                <td><?php echo e(showDateTime($debit->created_at, 'd M, Y h:i A')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="3" class="text-center text-white">No Debit Transactions</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/dashboard.blade.php ENDPATH**/ ?>