<?php $__env->startPush('topBar'); ?>
    <?php echo $__env->make('admin.plans.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>

    <div class="card b-radius--10">
        <div class="card-body p-0">
            <div class="table-responsive--md table-responsive">
                <table class="table table--light style--two">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Plan'); ?></th>
                            <th><?php echo app('translator')->get('Lock-in Days'); ?></th>
                            <th><?php echo app('translator')->get('Rate'); ?></th>
                            <th><?php echo app('translator')->get('Interval'); ?></th>
                            <th><?php echo app('translator')->get('Minimum Amount'); ?></th>
                            <th><?php echo app('translator')->get('Maximum Amount'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <?php if(can('admin.plans.fdr.save') || can('admin.plans.fdr.status')): ?>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <?php echo e(__($plan->name)); ?>

                                </td>

                                <td>
                                    <?php echo e($plan->locked_days); ?>

                                </td>

                                <td>
                                    <?php echo e(getAmount($plan->interest_rate)); ?>%
                                </td>

                                <td>
                                    <?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?>

                                </td>

                                <td>
                                    <?php echo e(showAmount($plan->minimum_amount)); ?>

                                </td>

                                <td>
                                    <?php echo e(showAmount($plan->maximum_amount)); ?>

                                </td>

                                <td> <?php echo $plan->statusBadge; ?> </td>

                                <?php if(can('admin.plans.fdr.save') || can('admin.plans.fdr.status')): ?>
                                    <td>
                                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.fdr.save')): ?>
                                            <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn" data-resource="<?php echo e($plan); ?>" data-modal_title="<?php echo app('translator')->get('Edit Plan'); ?>" data-has_status="1"><i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?>
                                            </button>
                                        <?php endif; ?>

                                        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.fdr.status')): ?>
                                            <?php if($plan->status): ?>
                                                <button type="button" data-action="<?php echo e(route('admin.plans.fdr.status', $plan->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to disable this plan?'); ?>" class="btn btn-sm confirmationBtn btn-outline--danger">
                                                    <i class="la la-la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?>
                                                </button>
                                            <?php else: ?>
                                                <button type="button" data-action="<?php echo e(route('admin.plans.fdr.status', $plan->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to enable this plan?'); ?>" class="btn btn-sm confirmationBtn btn-outline--success">
                                                    <i class="la la-la la-eye"></i><?php echo app('translator')->get('Enable'); ?>
                                                </button>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php if($plans->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($plans)); ?>

            </div>
        <?php endif; ?>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.fdr.save')): ?>
        <?php echo $__env->make('admin.plans.fdr.form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.fdr.save')): ?>
    <?php $__env->startPush('breadcrumb-plugins'); ?>
        <!-- Modal Trigger Button -->
        <button type="button" class="btn btn-sm btn-outline--primary cuModalBtn" data-modal_title="<?php echo app('translator')->get('Add Plan'); ?>">
            <i class="las la-plus"></i><?php echo app('translator')->get('Add Plan'); ?>
        </button>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/cu-modal.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            let modal = $("#cuModal");


            $('[name=interest_rate], [name=minimum_amount], [name=maximum_amount]').on('input', () => calculateProfit());

            function calculateProfit() {
                let minAmount = Number($('[name=minimum_amount]').val());
                let maxAmount = Number($('[name=maximum_amount]').val());
                let interest = Number($('[name=interest_rate]').val()) / 100;
                let interval = $('[name=installment_interval]').val();
                let totalMinAmount = minAmount * interest;
                let totalMaxAmount = maxAmount * interest;

                if (minAmount && maxAmount && interest) {
                    modal.find('#minAmount').text(`${showAmount(totalMinAmount)} <?php echo app('translator')->get(gs()->cur_text); ?>`);
                    modal.find('#maxAmount').text(`${showAmount(totalMaxAmount)} <?php echo app('translator')->get(gs()->cur_text); ?>`);
                    modal.find('#perInterval').text(interval);
                    modal.find('.final-amount').removeClass('d-none');
                }
            }

            $('#cuModal').on('show.bs.modal', function(e) {
                calculateProfit();
            });

            $('#cuModal').on('hidden.bs.modal', function(e) {
                modal.find('.final-amount').addClass('d-none');
            });

            if (new URLSearchParams(window.location.search).has('addnew')) {
                let cuModal = new bootstrap.Modal(document.getElementById('cuModal'));
                cuModal.show();
            }

            <?php if($errors->any()): ?>
                let cuModal = new bootstrap.Modal(document.getElementById('cuModal'));
                cuModal.show();
            <?php endif; ?>


        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/plans/fdr/index.blade.php ENDPATH**/ ?>