<ul class="caption-list-two p-0">
    <li>
        <span class="caption"><?php echo app('translator')->get('From Account'); ?></span>
        <span class="value text-end">
            <?php echo e($transfer->user->username); ?>

            <br>
            <?php echo e($transfer->user->account_number); ?>

        </span>
    </li>

    <?php if($transfer->wire_transfer_data): ?>
        <li>
            <span class="caption"><?php echo app('translator')->get('To Account Number'); ?></span>
            <span class="value"></span>

            <span class="value text-end">
                <?php echo e($transfer->wireTransferAccountName()); ?>

                <br>
                <?php echo e($transfer->wireTransferAccountNumber()); ?>

            </span>
        </li>
    <?php else: ?>
        <li>
            <span class="caption"><?php echo app('translator')->get('To Account'); ?></span>
            <span class="value text-end">
                <?php echo e($transfer->beneficiary->account_name); ?>

                <br>
                <?php echo e($transfer->beneficiary->account_number); ?>

            </span>
        </li>
    <?php endif; ?>

    <?php if($transfer->beneficiary && $transfer->beneficiary->beneficiary_type == OtherBank::class): ?>
        <li>
            <span class="caption"><?php echo app('translator')->get('Recipient Bank Name'); ?></span>
            <span class="value"><?php echo e(__($transfer->beneficiary->beneficiaryOf->name)); ?> </span>
        </li>
    <?php endif; ?>

    <li>
        <span class="caption"><?php echo app('translator')->get('Transfer Amount'); ?></span>
        <span class="value text-end">
            <small><?php echo e(__(gs('cur_text'))); ?></small>
            <br>
            <?php echo e(showAmount($transfer->amount, currencyFormat: false)); ?>

        </span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Time'); ?></span>
        <span class="value text-end">
            <?php echo e(showDateTime($transfer->created_at, 'F d, Y')); ?>

            <br>
            <?php echo e(showDateTime($transfer->created_at, 'h:i A')); ?>

        </span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('TRX Number'); ?></span>
        <span class="value">#<?php echo e($transfer->trx); ?></span>
    </li>
</ul>

<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/partials/user/transfer_details.blade.php ENDPATH**/ ?>