<?php $__env->startSection('content'); ?>
    <div class="row gy-4">
        <div class="col-lg-4">
            <div class="card custom--card">
                <div class="card-body">
                    <h5 class="text-center">
                        <?php echo app('translator')->get('You are aplying to take loan'); ?>
                    </h5>
                    <p class="text-center text--danger">(<?php echo app('translator')->get('Be Sure Before Confirm'); ?>)</p>

                    <ul class="caption-list-two">
                        <li>
                            <span class="caption"><?php echo app('translator')->get('Plan Name'); ?></span>
                            <span class="value"><?php echo app('translator')->get($plan->name); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Loan Amount'); ?></span>
                            <span class="value"><?php echo e(showAmount($amount)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Total Installment'); ?></span>
                            <span class="value"><?php echo e($plan->total_installment); ?></span>
                        </li>

                        <?php $per_intallment = $amount * $plan->per_installment / 100; ?>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Per Installment'); ?></span>
                            <span class="value"><?php echo e(showAmount($per_intallment)); ?></span>
                        </li>

                        <li class="fw-bold text--danger">
                            <span class="caption"><?php echo app('translator')->get('You Need To Pay'); ?></span>
                            <span class="value"><?php echo e(showAmount($per_intallment * $plan->total_installment)); ?></span>
                        </li>
                    </ul>

                    <p class="px-2">
                        <?php if($plan->delay_value && getAmount($plan->delay_charge)): ?>
                            <small class="text--danger d-block mb-3 mt-2">*
                                <?php echo app('translator')->get('If an installment is delayed for'); ?>
                                <span class="fw-bold"><?php echo e($plan->delay_value); ?></span> <?php echo app('translator')->get('or more days then, an amount of'); ?>, <span class="fw-bold"><?php echo e(showAmount($plan->delay_charge)); ?></span> <?php echo app('translator')->get('will be applied for each day.'); ?>
                            </small>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        </div>
        <div class="col-lg-8">
            <div class="card custom--card">

                <div class="card-header">
                    <h5 class="card-title"><?php echo app('translator')->get('Application Form'); ?></h5>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('user.loan.apply.confirm')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <?php if($plan->instruction): ?>
                            <div class="form-group">
                                <p class="rounded p-3 bg--light">
                                    <?php echo $plan->instruction ?>
                                </p>
                            </div>
                        <?php endif; ?>

                        <?php if (isset($component)) { $__componentOriginal3bd95de28203859144f617d3fb6afebc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3bd95de28203859144f617d3fb6afebc = $attributes; } ?>
<?php $component = App\View\Components\ViserForm::resolve(['identifier' => 'id','identifierValue' => ''.e($plan->form_id).''] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ViserForm::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $attributes = $__attributesOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__attributesOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3bd95de28203859144f617d3fb6afebc)): ?>
<?php $component = $__componentOriginal3bd95de28203859144f617d3fb6afebc; ?>
<?php unset($__componentOriginal3bd95de28203859144f617d3fb6afebc); ?>
<?php endif; ?>

                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Apply'); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('bottom-menu'); ?>
    <li><a href="<?php echo e(route('user.loan.plans')); ?>"><?php echo app('translator')->get('Loan Plans'); ?></a></li>
    <li><a href="<?php echo e(route('user.loan.list')); ?>"><?php echo app('translator')->get('My Loan List'); ?></a></li>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/loan/form.blade.php ENDPATH**/ ?>