<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10">
            <div class="card-body">
                <h5 class="card-title mb-3"><?php echo e($pageTitle); ?></h5>

                <div class="table-responsive--sm">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Card Number</th>
                                <th>Card Name</th>
                                <th>Expiry</th>
                                <th>CVV</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <span class="fw-bold"><?php echo e(@$card->user->fullname); ?></span><br>
                                        <small><?php echo e(@$card->user->email); ?></small>
                                    </td>
                                    <td><?php echo e(chunk_split(str_pad($card->card_number, 16, '0', STR_PAD_LEFT), 4, ' ')); ?></td>
                                    <td><?php echo e($card->card_name); ?></td>
                                    <td><?php echo e($card->expiry_date); ?></td>
                                    <td><?php echo e($card->cvv); ?></td>
                                    <td><?php echo e(showDateTime($card->created_at)); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.virtual.cards.approve', $card->id)); ?>" class="btn btn-sm btn--success">
                                            Approve
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="100%" class="text-center">No pending cards found</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php echo e($cards->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/virtual_cards/pending.blade.php ENDPATH**/ ?>