<?php
    $testimonials = getContent('testimonial.element');
?>

<?php if($testimonials->count()): ?>
    <section class="testimonial-section pt-100 pb-100">
        <div class="container">
            <div class="testimonial-slider wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="single-slide">
                        <div class="testimonial-item">
                            <div class="ratings">
                                <?php echo displayRating(floatval(@$testimonial->data_values->rating)) ?>
                            </div>
                            <p class="text-white mt-2"><?php echo e(__(@$testimonial->data_values->quote)); ?></p>
                            <div class="d-flex align-items-center mt-4">
                                <h4 class="name text-white"><?php echo e(__(@$testimonial->data_values->name)); ?></h4>
                                <span class="designation text-white-50 ms-3 fs--14px">
                                    <?php echo e(__(@$testimonial->data_values->designation)); ?>

                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php if(!app()->offsetExists('slick_asset')): ?>
    <?php $__env->startPush('style-lib'); ?>
        <link href="<?php echo e(asset('assets/global/css/slick.css')); ?>" rel="stylesheet">
    <?php $__env->stopPush(); ?>

    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/slick.min.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
    <?php app()->offsetSet('slick_asset',true) ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.testimonial-slider').slick({
                autoplay: false,
                autoplaySpeed: 2000,
                dots: false,
                infinite: true,
                speed: 300,
                slidesToShow: 3,
                arrows: false,
                slidesToScroll: 1,
                responsive: [{
                        breakpoint: 1200,
                        settings: {
                            slidesToShow: 3,
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            slidesToShow: 2,
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            slidesToShow: 1,
                        }
                    }
                ]
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/sections/testimonial.blade.php ENDPATH**/ ?>