<?php $__env->startSection('content'); ?>
    <?php if(gs()->modules->own_bank): ?>
        <div class="d-flex flex-wrap justify-content-end mb-3">
            <a class="btn btn-sm btn--dark" href="<?php echo e(route('user.beneficiary.own')); ?>"> <i class="la la-users"></i> <?php echo app('translator')->get('Manage Beneficiaries'); ?></a>
        </div>
    <?php endif; ?>

    <div class="custom--card">
        <div class="table-responsive--md">
            <table class="custom--table table">
                <thead>
                    <tr>
                        <th><?php echo app('translator')->get('Name'); ?></th>
                        <th><?php echo app('translator')->get('Account No.'); ?></th>
                        <th><?php echo app('translator')->get('Account Name'); ?></th>
                        <th><?php echo app('translator')->get('Details'); ?></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($beneficiary->short_name); ?></td>
                            <td><?php echo e($beneficiary->account_number); ?> </td>
                            <td><?php echo e($beneficiary->account_name); ?></td>
                            <td>
                                <button class="btn btn-sm btn-outline--base sendBtn" data-id="<?php echo e($beneficiary->id); ?>">
                                    <i class="las la-hand-holding-usd"></i> <?php echo app('translator')->get('Transfer Money'); ?>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-center" colspan="100%"><?php echo app('translator')->get($emptyMessage); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php if($beneficiaries->hasPages()): ?>
    <div class="mt-3">
        <?php echo e(paginateLinks($beneficiaries)); ?>

    </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php if (isset($component)) { $__componentOriginalfaab69ae368581dbfbc77a98d132296d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfaab69ae368581dbfbc77a98d132296d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transfer-bottom-menu','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transfer-bottom-menu'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfaab69ae368581dbfbc77a98d132296d)): ?>
<?php $attributes = $__attributesOriginalfaab69ae368581dbfbc77a98d132296d; ?>
<?php unset($__attributesOriginalfaab69ae368581dbfbc77a98d132296d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfaab69ae368581dbfbc77a98d132296d)): ?>
<?php $component = $__componentOriginalfaab69ae368581dbfbc77a98d132296d; ?>
<?php unset($__componentOriginalfaab69ae368581dbfbc77a98d132296d); ?>
<?php endif; ?>

<?php $__env->startPush('modal'); ?>
    <div class="modal fade" id="sendModal">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Transfer Money'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <h6 class="text-end"><?php echo app('translator')->get('Current Balance'); ?>: <?php echo e(showAmount(auth()->user()->balance)); ?></h6>
                        <div class="form-group">
                            <label class="required"><?php echo app('translator')->get('Amount'); ?></label>
                            <div class="input-group">
                                <input class="form--control" name="amount" type="text" required>
                                <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                            </div>
                        </div>

                        <?php echo $__env->make($activeTemplate . 'partials.otp_field', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <div class="my-4">
                            <ul class="caption-list-two p-0">
                                <li>
                                    <span class="caption"><?php echo app('translator')->get('Limit Per Transaction'); ?></span>
                                    <span class="value"><?php echo e(showAmount(gs()->minimum_transfer_limit)); ?> (<?php echo app('translator')->get('Min'); ?>)</span>
                                </li>

                                <li>
                                    <span class="caption"><?php echo app('translator')->get('Daily Limit'); ?></span>
                                    <span class="value"><?php echo e(showAmount(gs()->daily_transfer_limit)); ?> (<?php echo app('translator')->get('Max'); ?>)</span>
                                </li>

                                <li>
                                    <span class="caption"><?php echo app('translator')->get('Monthly Limit'); ?></span>
                                    <span class="value"><?php echo e(showAmount(gs()->monthly_transfer_limit)); ?> (<?php echo app('translator')->get('Max'); ?>)</span>
                                </li>

                                <?php $transferCharge = gs()->transferCharge(); ?>

                                <?php if($transferCharge): ?>
                                    <li>
                                        <span class="caption"><?php echo app('translator')->get('Charge Per Transaction'); ?></span>
                                        <span class="value text--danger"> <?php echo e($transferCharge); ?></span>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </div>

                        <button class="btn btn--base w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('.sendBtn').on('click', function() {
                let modal = $('#sendModal');
                let route = `<?php echo e(route('user.transfer.own.bank.request', ':id')); ?>`;
                modal.find('form')[0].action = route.replace(':id', $(this).data('id'))
                modal.modal('show');
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/transfer/own_bank/beneficiaries.blade.php ENDPATH**/ ?>