<?php
    $finishTime = \Carbon\Carbon::parse($verification->expired_at);
    $currentTime = now();
    $totalDuration = $currentTime > $finishTime ? 0 : floor($currentTime->diffInSeconds($finishTime));
?>

<div class="text-center mb-4 card-img-top bg--dark p-3">
    <?php if($verification->send_via == 'email'): ?>
        <p class="text-white"><?php echo app('translator')->get('Please check your email to get a six digit OTP'); ?></p>
    <?php else: ?>
        <p class="text-white"><?php echo app('translator')->get('Please check your mobile to get a six digit OTP'); ?></p>
    <?php endif; ?>

    <?php if($totalDuration): ?>
        <p class="mt-2 text--warning otp-warning"><?php echo app('translator')->get('OTP will be expired in the next'); ?></p>
    <?php endif; ?>

    <div class="d-flex justify-content-center mb-3">
        <div class="expired-time-circle <?php if(!$totalDuration): ?> danger-border <?php endif; ?>">
            <div class="exp-time"><?php echo e($totalDuration); ?></div>
            <?php echo app('translator')->get('Seconds'); ?>
            <div class="animation-circle"></div>
        </div>
        <div class="border-circle"></div>
    </div>

    <div class="try-btn-wrapper mt-2 d-none">
        <p class="text-danger "><?php echo app('translator')->get('Your OTP has been expired'); ?> </p>
        <form method="POST" action="<?php echo e(route('user.otp.resend', $verification->id)); ?>" class="w-100 mt-2">
            <?php echo csrf_field(); ?>
            <button type="submit" class="rounded btn--success text-white"><?php echo app('translator')->get('Resend OTP'); ?></button>
        </form>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {

            let secondsLeft = `<?php echo e($totalDuration); ?>` * 1;
            setInterval(function() {
                if (secondsLeft) {
                    secondsLeft--;
                }

                if (secondsLeft == 0) {
                    $('.try-btn-wrapper').removeClass('d-none');
                    $('.otp-warning').addClass('d-none');
                    $('.expired-time-circle').addClass('danger-border')
                }

                $(".exp-time").text(secondsLeft);
            }, 1000);

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset('assets/global/css/otp_timer.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .animation-circle {
            position: absolute;
            top: 0;
            left: 0;
            border: 4px solid #f44336;
            height: 100%;
            width: 100%;
            border-radius: 150px;
            box-shadow: 1px 1px 1px 1px rgba(255, 0, 0, 0.5);
            transform: rotateY(180deg);
            animation-name: clipCircle;
            animation-duration: <?php echo e(@$totalDuration); ?>s;
            animation-iteration-count: 1;
            animation-timing-function: cubic-bezier(0, 0, 1, 1);
            z-index: 1;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/user/otp/email_sms.blade.php ENDPATH**/ ?>