<?php $__env->startSection('panel'); ?>

    <?php
        $request = request();
        $tableName = 'dps_list';

        $tableConfiguration = $tableConfiguration = tableConfiguration($tableName);

        $columns = collect([
            prepareTableColumn('dps_number', 'DPS No.'),
            prepareTableColumn('account_number', 'Account No.', link:'route("admin.users.detail", $item->user_id)'),
            prepareTableColumn('plan_name', 'Plan'),
            prepareTableColumn('interest_rate', 'Rate', 'getAmount($item->interest_rate)."%"', filter: 'range'),
            prepareTableColumn('installment_interval', 'Interval', '$item->installment_interval ." Days"', filter: 'range'),
            prepareTableColumn('per_installment', 'Installment', 'showAmount($item->per_installment)', filter: 'range'),
            prepareTableColumn('total_installment', 'Total Inst.', 'getAmount($item->total_installment)', filter: 'range'),
            prepareTableColumn('given_installment', 'Given Inst.', 'getAmount($item->given_installment)', filter: 'range'),
            prepareTableColumn('due_installments_count', 'Late Inst.', '$item->late_installments_count', filter: 'range'),
            prepareTableColumn('next_installment_date', 'Next Inst. Date', 'showDateTime("$item->next_installment_date", "d M, Y")', filter: 'date'),
            prepareTableColumn('deposit_amount', 'Deposit Amount', 'showAmount($item->deposit_amount)', filter: 'range'),
            prepareTableColumn('profit_amount', 'Profit Amount', 'showAmount($item->profit_amount)', filter: 'range'),
            prepareTableColumn('total_amount', 'Total Amount', 'showAmount($item->total_amount)', filter: 'range'),
            prepareTableColumn('created_at', 'Opened At', 'showDateTime("$item->created_at", "d M, Y")', filter: 'date'),
            prepareTableColumn('status', 'Status', '$item->status_badge', echoable:true)
        ]);

        $action = [
            'name' => 'Action',
            'style' => '',
            'show' => can('admin.dps.installments'),
            'buttons' => [
                [
                    'icon' => 'las la-history',
                    'name' => 'Installments',
                    'link' => 'route("admin.dps.installments", $item->id)',
                    'show' => "can('admin.dps.installments')",
                    'class' => 'btn-outline--primary',
                ],
            ],
        ];

        if ($tableConfiguration) {
            $visibleColumns = $tableConfiguration->visible_columns;
        } else {
            $visibleColumns = $columns->pluck('id')->toArray();
        }
    ?>

    <?php if (isset($component)) { $__componentOriginala9d13211d16a9b68016cb700b31e0809 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala9d13211d16a9b68016cb700b31e0809 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table','data' => ['data' => $data,'columns' => $columns,'action' => $action,'columnConfig' => true,'tableName' => $tableName,'visibleColumns' => $visibleColumns,'class' => 'table-responsive--md table-responsive','searchPlaceholder' => 'DPS No. / Account No.']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($data),'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($columns),'action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($action),'columnConfig' => true,'tableName' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableName),'visibleColumns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($visibleColumns),'class' => 'table-responsive--md table-responsive','searchPlaceholder' => 'DPS No. / Account No.']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $attributes = $__attributesOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__attributesOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $component = $__componentOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__componentOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/dps/index.blade.php ENDPATH**/ ?>