<?php if (\Illuminate\Support\Facades\Blade::check('can', ['admin.plans.fdr.index', 'admin.plans.dps.index', 'admin.plans.loan.index'])): ?>
    <ul class="nav nav-tabs mb-4 topTap breadcrumb-nav" role="tablist">
        <button class="breadcrumb-nav-close"><i class="las la-times"></i></button>
        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.fdr.index')): ?>
            <li class="nav-item <?php echo e(menuActive('admin.plans.fdr*')); ?>" role="presentation">
                <a href="<?php echo e(route('admin.plans.fdr.index')); ?>" class="nav-link text-dark" type="button">
                    <?php echo app('translator')->get('FDR Plans'); ?>
                </a>
            </li>
        <?php endif; ?>
        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.dps.index')): ?>
            <li class="nav-item <?php echo e(menuActive('admin.plans.dps*')); ?>" role="presentation">
                <a href="<?php echo e(route('admin.plans.dps.index')); ?>" class="nav-link text-dark" type="button">
                    <?php echo app('translator')->get('DPS Plans'); ?>
                </a>
            </li>
        <?php endif; ?>

        <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.loan.index')): ?>
            <li class="nav-item <?php echo e(menuActive('admin.plans.loan*')); ?>" role="presentation">
                <a href="<?php echo e(route('admin.plans.loan.index')); ?>" class="nav-link text-dark" type="button">
                    <?php echo app('translator')->get('Loan Plans'); ?>
                </a>
            </li>
        <?php endif; ?>
    </ul>
<?php endif; ?>
<?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/plans/top_bar.blade.php ENDPATH**/ ?>