<?php $__env->startPush('topBar'); ?>
    <?php echo $__env->make('admin.plans.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card  b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Plan'); ?></th>
                                    <th><?php echo app('translator')->get('Per Installment'); ?></th>
                                    <th><?php echo app('translator')->get('Total Installment'); ?></th>
                                    <th><?php echo app('translator')->get('Interval'); ?></th>
                                    <th><?php echo app('translator')->get('Min Limit'); ?></th>
                                    <th><?php echo app('translator')->get('Max Limit'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <?php if(can('admin.plans.loan.edit') || can('admin.plans.loan.status')): ?>
                                        <th><?php echo app('translator')->get('Action'); ?></th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(__($plan->name)); ?></td>

                                        <td><?php echo e(getAmount($plan->per_installment )); ?>%</td>

                                        <td><?php echo e($plan->installment_interval); ?> <?php echo e(__(Str::plural('Day', $plan->installment_interval))); ?></td>

                                        <td><?php echo e($plan->total_installment); ?></td>

                                        <td><?php echo e(showAmount($plan->minimum_amount)); ?></td>

                                        <td><?php echo e(showAmount($plan->maximum_amount)); ?></td>

                                        <td> <?php echo $plan->statusBadge; ?> </td>

                                        <?php if(can('admin.plans.loan.edit') || can('admin.plans.loan.status')): ?>
                                            <td>
                                                <div class="button--group">
                                                    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.loan.edit')): ?>
                                                        <a href="<?php echo e(route('admin.plans.loan.edit', $plan->id)); ?>" class="btn btn-sm btn-outline--primary">
                                                            <i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?>
                                                        </a>
                                                    <?php endif; ?>

                                                    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.loan.status')): ?>
                                                        <?php if($plan->status): ?>
                                                            <button type="button" data-action="<?php echo e(route('admin.plans.loan.status', $plan->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to disable this plan?'); ?>" class="btn btn-sm confirmationBtn btn-outline--danger">
                                                                <i class="la la-la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?>
                                                            </button>
                                                        <?php else: ?>
                                                            <button type="button" data-action="<?php echo e(route('admin.plans.loan.status', $plan->id)); ?>" data-question="<?php echo app('translator')->get('Are you sure to enable this plan?'); ?>" class="btn btn-sm confirmationBtn btn-outline--success">
                                                                <i class="la la-la la-eye"></i><?php echo app('translator')->get('Enable'); ?>
                                                            </button>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        <?php endif; ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($plans->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($plans)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.loan.create')): ?>
    <?php $__env->startPush('breadcrumb-plugins'); ?>
        <a href="<?php echo e(route('admin.plans.loan.create')); ?>" class="btn btn-sm btn-outline--primary">
            <i class="la la-plus"></i> <?php echo app('translator')->get('Add New'); ?>
        </a>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/plans/loan/index.blade.php ENDPATH**/ ?>