<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center gy-4">
        <?php if(!auth()->user()->ts): ?>
            <div class="col-md-6">
                <div class="card custom--card">

                    <div class="card-body">
                        <h5 class="card-title text-center"><?php echo app('translator')->get('Add Your Account'); ?></h5>
                        <p class="my-3 mb-3">
                            <?php echo app('translator')->get('Use the QR code or setup key on your Google Authenticator app to add your account.'); ?>
                        </p>

                        <div class="form-group mx-auto text-center">
                            <img class="mx-auto" src="<?php echo e($qrCodeUrl); ?>">
                        </div>

                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Setup Key'); ?></label>
                            <div class="input-group">
                                <input class="form--control referralURL" name="key" type="text" value="<?php echo e($secret); ?>" readonly>
                                <button class="input-group-text copytext" id="copyBoard" type="button"> <i class="fa fa-copy"></i> </button>
                            </div>
                        </div>

                        <label><i class="fa fa-info-circle"></i> <?php echo app('translator')->get('Help'); ?></label>
                        <p><?php echo app('translator')->get('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.'); ?> <a class="text--base" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en" target="_blank"><?php echo app('translator')->get('Download'); ?></a></p>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="col-md-6">

            <?php if(auth()->user()->ts): ?>
                <div class="card custom--card">
                    <div class="card-body">
                        <h5 class="card-title text-center"><?php echo app('translator')->get('Disable 2FA Security'); ?></h5>
                        <form action="<?php echo e(route('user.twofactor.disable')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input name="key" type="hidden" value="<?php echo e($secret); ?>">
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('Google Authenticator OTP'); ?></label>
                                <input class="form--control" name="code" type="text" required>
                            </div>
                            <button class="btn btn-md btn--base w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <div class="card custom--card">
                    <div class="card-body">
                        <h5 class="card-title text-center"><?php echo app('translator')->get('Enable 2FA Security'); ?></h5>
                        <form action="<?php echo e(route('user.twofactor.enable')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input name="key" type="hidden" value="<?php echo e($secret); ?>">
                            <div class="form-group">
                                <label class="form-label"><?php echo app('translator')->get('Google Authenticator OTP'); ?></label>
                                <input class="form--control" name="code" type="text" required>
                            </div>
                            <button class="btn btn-md btn--base w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .copied::after {
            background-color: #<?php echo e(gs()->base_color); ?>;
        }

        .form--control[readonly] {
            background-color: #ffffff;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('#copyBoard').click(function() {
                var copyText = document.getElementsByClassName("referralURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                copyText.blur();
                this.classList.add('copied');
                setTimeout(() => this.classList.remove('copied'), 1500);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('bottom-menu'); ?>
    <li><a href="<?php echo e(route('user.profile.setting')); ?>"><?php echo app('translator')->get('Profile'); ?></a></li>
    <li><a href="<?php echo e(route('user.referral.users')); ?>"><?php echo app('translator')->get('Referral'); ?></a></li>
    <li><a class="active" href="<?php echo e(route('user.twofactor')); ?>"><?php echo app('translator')->get('2FA Security'); ?></a></li>
    <li><a href="<?php echo e(route('user.change.password')); ?>"><?php echo app('translator')->get('Change Password'); ?></a></li>
    <li><a href="<?php echo e(route('user.transaction.history')); ?>"><?php echo app('translator')->get('Transactions'); ?></a></li>
    <li><a class="<?php echo e(menuActive(['ticket.*'])); ?>" href="<?php echo e(route('ticket.index')); ?>"><?php echo app('translator')->get('Support Tickets'); ?></a></li>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/twofactor.blade.php ENDPATH**/ ?>