<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-xl-8 col-lg-12">

            <div class="card custom--card">
                <div class="card-body">

                    <div class="d-flex flex-wrap gap-3 justify-content-between align-items-start mb-3">
                        <h5 class="card-title mb-3"><?php echo app('translator')->get('Deposit Info'); ?></h5>
                        <?php echo $deposit->statusBadge ?>
                    </div>

                    <ul class="caption-list-two p-0">
                        <li>
                            <span class="caption"><?php echo app('translator')->get('TRX No.'); ?></span>
                            <span class="value">#<?php echo e($deposit->trx); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Amount'); ?></span>
                            <span class="value fw-bold"><?php echo e(showAmount($deposit->amount)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Charge'); ?></span>
                            <span class="value text--danger"><?php echo e(showAmount($deposit->charge)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('After Charge'); ?></span>
                            <span class="value fw-bold"><?php echo e(showAmount($deposit->amount + $deposit->charge)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Conversion Rate'); ?></span>
                            <span class="value">1 <?php echo e(__(gs()->cur_text)); ?> = <?php echo e(showAmount($deposit->rate, currencyFormat: false)); ?> <?php echo e(__($deposit->method_currency)); ?></span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('After Convert'); ?></span>
                            <span class="value fw-bold text--info">
                                <?php echo e(showAmount($deposit->final_amount, currencyFormat: false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                            </span>
                        </li>

                        <li>
                            <span class="caption"><?php echo app('translator')->get('Created At'); ?></span>
                            <span class="value"><?php echo e(showDateTime($deposit->created_at)); ?></span>
                        </li>

                        <li>
                            <?php if($deposit->branch): ?>
                                <span class="caption"><?php echo app('translator')->get('Branch'); ?></span>
                                <span class="value text-primary"><?php echo e(__(@$deposit->branch->name)); ?></span>
                            <?php else: ?>
                                <span class="caption"><?php echo app('translator')->get('Gateway'); ?></span>
                                <span class="value text-primary fw-bold"><?php echo e(__(@$deposit->gateway->name)); ?></span>
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>

            <?php if($deposit->status == Status::PAYMENT_REJECT): ?>
                <div class="card custom--card mt-3">
                    <div class="card-body">
                        <h5 class="card-title mb-3"><?php echo app('translator')->get('Reason for Rejection'); ?></h5>
                        <?php echo e($deposit->admin_feedback); ?>

                    </div>
                </div>

            <?php endif; ?>

            <?php if($deposit->method_code >= 1000): ?>
                <div class="card custom--card mt-3">
                    <div class="card-body">
                        <h5 class="card-title mb-3"><?php echo app('translator')->get('Submitted Data'); ?></h5>
                        <?php
                            $details = $deposit->detail != null ? $deposit->detail : null;
                        ?>
                        <ul class="caption-list-two p-0">
                            <?php $__currentLoopData = $details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <span class="caption"><?php echo e($detail->name); ?></span>
                                    <span class="value">
                                        <?php if($detail->type == 'checkbox'): ?>
                                            <?php echo e(implode(',', $detail->value)); ?>

                                        <?php elseif($detail->type == 'file'): ?>
                                            <?php if($detail->value): ?>
                                                <a href="<?php echo e(route('admin.download.attachment', encrypt(getFilePath('verify') . '/' . $detail->value))); ?>"><i class="fa-regular fa-file"></i> <?php echo app('translator')->get('Attachment'); ?> </a>
                                            <?php else: ?>
                                                <?php echo app('translator')->get('No File'); ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <p><?php echo e(__($detail->value)); ?></p>
                                        <?php endif; ?>
                                    </span>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>

                    </div>
                </div>
            <?php endif; ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/user/deposit/details.blade.php ENDPATH**/ ?>