<?php $__env->startSection('content'); ?>
<div class="row justify-content-center mt-5">
    <div class="col-md-6">
        <div class="card custom--card text-center">
            <div class="card-body">
                
                <div class="mb-4">
                    <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . auth()->user()->image, null, true)); ?>" 
                         alt="user" 
                         style="width: 100px; height: 100px; border-radius: 50%; object-fit: cover;">
                    <h5 class="mt-3 mb-0"><?php echo e(auth()->user()->fullname); ?></h5>
                </div>

                <form method="POST" action="<?php echo e(route('user.verify.pin.submit')); ?>">
                    <?php echo csrf_field(); ?>

                    <input type="hidden" name="pin" class="pin-input">

                    <div class="form-group text-center">
                        <label><?php echo app('translator')->get('Enter Your 4-Digit PIN'); ?></label>
                        <input type="password" class="form--control pin-visible-input text-center mb-3" placeholder="••••" maxlength="4" readonly style="letter-spacing: 10px; font-size: 24px;">

                        <div id="pinKeypad" class="pin-keypad mx-auto mt-2"></div>

                        <?php $__errorArgs = ['pin'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger mt-2 d-block"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <button type="submit" class="btn btn--base w-100 mt-3"><?php echo app('translator')->get('Verify PIN'); ?></button>

                    <div class="text-center mt-3">
                        <a href="<?php echo e(route('user.pin.reset')); ?>" class="text--base"><?php echo app('translator')->get('Forgot PIN? Reset it here'); ?></a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
<style>
    .pin-keypad {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 10px;
        max-width: 220px;
        margin: 0 auto;
    }

    .pin-key {
        padding: 12px;
        font-size: 18px;
        background-color: #f1f1f1;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }

    .pin-key:active {
        background-color: #ddd;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    "use strict";
    (function($) {
        const pinInput = document.querySelector('.pin-input');
        const pinVisible = document.querySelector('.pin-visible-input');
        const pinKeypad = document.getElementById('pinKeypad');

        const createShuffledKeypad = () => {
            let keys = [...Array(10).keys()];
            keys = keys.sort(() => Math.random() - 0.5); // shuffle digits

            let keypadHTML = '';
            keys.forEach(d => {
                keypadHTML += `<button type="button" class="pin-key">${d}</button>`;
            });
            keypadHTML += `<button type="button" class="pin-key" id="pin-clear">←</button>`;
            pinKeypad.innerHTML = keypadHTML;

            attachEvents(); // re-attach events after shuffling
        };

        const attachEvents = () => {
            const pinKeys = document.querySelectorAll('.pin-key');
            pinKeys.forEach(key => {
                key.addEventListener('click', () => {
                    if (key.id === 'pin-clear') {
                        pinInput.value = pinInput.value.slice(0, -1);
                    } else if (pinInput.value.length < 4) {
                        pinInput.value += key.textContent.trim();
                    }
                    pinVisible.value = '*'.repeat(pinInput.value.length);
                    createShuffledKeypad(); // shuffle after each press
                });
            });
        };

        createShuffledKeypad();
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/user/verify_pin.blade.php ENDPATH**/ ?>