<?php foreach ((['columns']) as $__key => $__value) {
    $__consumeVariable = is_string($__key) ? $__key : $__value;
    $$__consumeVariable = is_string($__key) ? $__env->getConsumableComponentData($__key, $__value) : $__env->getConsumableComponentData($__value);
} ?>

<?php
    $request = request();
?>

<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasRightLabel"><?php echo app('translator')->get('Filter Data'); ?></h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>

    <div class="offcanvas-body">
        <?php if(request()->has('filter') || request()->has('range_filter') || request()->has('date_filter')): ?>
            <div class="d-flex justify-content-end">
                <button type="button" class="btn btn--dark" id="clearFilter">
                    <?php echo app('translator')->get('Clear Filter'); ?>
                </button>
            </div>
        <?php endif; ?>

        <form action="" method="get" id="filterForm">
            <?php $__currentLoopData = collect($columns)->whereNotNull('filter'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $column = (object) $column;
                ?>

                <?php if($column->filter == 'text' || $column->filter == 'number'): ?>
                    <div class="mb-3 filter-field position-relative">
                        <label><?php echo e(__($column->name)); ?></label>
                        <input type="<?php echo e($column->filter); ?>" name="filter[<?php echo e($column->id); ?>]" value="<?php echo e(@$request->filter[$column->id]); ?>" class="form-control">
                    </div>
                <?php elseif($column->filter == 'select' && !blank($column->filter_options)): ?>
                    <div class="mb-3 filter-field position-relative">
                        <label><?php echo e(__($column->name)); ?></label>
                        <select name="filter[<?php echo e($column->filter_column); ?>]" class="form-control">
                            <option value=""><?php echo app('translator')->get('All'); ?></option>
                            <?php if($column->filter_options && is_assoc(@$column->filter_options)): ?>
                                <?php $__currentLoopData = $column->filter_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e(@$key); ?>" <?php if($request->has('filter.' . $column->filter_column) && $request->filter[$column->filter_column] == $key): echo 'selected'; endif; ?>><?php echo e(__($option)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <?php $__currentLoopData = $column->filter_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e(@$option); ?>" <?php if($request->filter && @$request->filter[$column->filter_column]): ?> <?php if(@$request->filter[$column->filter_column] == $option): echo 'selected'; endif; ?> <?php endif; ?>><?php echo e(__($option)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </select>
                    </div>
                <?php elseif($column->filter == 'range'): ?>
                    <div class="mb-3 filter-field position-relative">
                        <label><?php echo e(__($column->name)); ?></label>
                        <div class="input-group">
                            <input type="number" step="any" name="range_filter[<?php echo e($column->id); ?>][min]" value="<?php echo e(@$request['range_filter'][$column->id]['min']); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Min'); ?>">

                            <input type="number" step="any" name="range_filter[<?php echo e($column->id); ?>][max]" value="<?php echo e(@$request['range_filter'][$column->id]['max']); ?>" class="form-control" placeholder="<?php echo app('translator')->get('Max'); ?>">
                        </div>
                    </div>
                <?php elseif($column->filter == 'date'): ?>
                    <div class="mb-3 filter-field position-relative">
                        <label><?php echo e(__($column->name)); ?></label>
                        <input type="text" name="date_filter[<?php echo e($column->id); ?>]" value="<?php echo e(@$request->date_filter[$column->id]); ?>" class="form-control date-range" autocomplete="off">
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </form>
    </div>

    <div class="position-sticky p-3">
        <button type="submit" class="btn btn--primary w-100 h-45" form="filterForm"><?php echo app('translator')->get('Apply Filter'); ?></button>
    </div>
</div>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/admin/js/daterangepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/admin/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/components/viser_table/table-filter.blade.php ENDPATH**/ ?>