<ul class="caption-list-two mt-3 p-0">
    <li>
        <span class="caption"><?php echo app('translator')->get('DPS No.'); ?></span>
        <span class="value fw-bold">#<?php echo e($dps->dps_number); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Plan'); ?></span>
        <span class="value"><?php echo e(__($dps->plan->name)); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Interest Rate'); ?></span>
        <span class="value"><?php echo e(getAmount($dps->plan->interest_rate)); ?>%</span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Opened On'); ?></span>
        <span class="value"><?php echo e(showDateTime($dps->created_at, 'd M, Y')); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Installment Interval'); ?></span>
        <span class="value"><?php echo e($dps->installment_interval); ?> <?php echo e(__(Str::plural('Day', $dps->installment_interval))); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Per Installment'); ?></span>
        <span class="value fw-bold"><?php echo e(showAmount($dps->per_installment)); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Total Installment'); ?></span>
        <span class="value fw-bold"><?php echo e($dps->total_installment); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Given Installment'); ?></span>
        <span class="value fw-bold"><?php echo e($dps->given_installment); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Deposited Amount'); ?></span>
        <span class="value fw-bold"><?php echo e(showAmount($dps->per_installment * $dps->given_installment)); ?></span>
    </li>

    <?php if($dps->nextInstallment): ?>
        <li>
            <span class="caption"><?php echo app('translator')->get('Next Installment Date'); ?></span>
            <span class="value fw-bold text--warning"><?php echo e(showDateTime($dps->nextInstallment->installment_date, 'd M, Y')); ?></span>
        </li>
    <?php endif; ?>

    <li>
        <span class="caption"><?php echo app('translator')->get('DPS Amount'); ?></span>
        <span class="value fw-bold"><?php echo e(showAmount($dps->depositedAmount())); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Profit Amount'); ?></span>
        <span class="value fw-bold"><?php echo e(showAmount($dps->plan->final_amount - $dps->depositedAmount())); ?></span>
    </li>

    <li>
        <span class="caption"><?php echo app('translator')->get('Maturity Amount'); ?></small></span>
        <span class="value fw-bold"><?php echo e(showAmount($dps->plan->final_amount)); ?></span>
    </li>

</ul>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/partials/user/dps_details.blade.php ENDPATH**/ ?>