<?php $__env->startSection('panel'); ?>
    <div class="row mb-none-30">
        <div class="col-lg-12 col-md-12 mb-30">
            <form method="POST" action="<?php echo e(route('admin.setting.update')); ?>">
                <div class="card">
                    <div class="card-body">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label> <?php echo app('translator')->get('Site Title'); ?></label>
                                    <input class="form-control" type="text" name="site_name" required value="<?php echo e(gs('site_name')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Currency'); ?></label>
                                    <input class="form-control" type="text" name="cur_text" required value="<?php echo e(gs('cur_text')); ?>">
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6">
                                <div class="form-group ">
                                    <label><?php echo app('translator')->get('Currency Symbol'); ?></label>
                                    <input class="form-control" type="text" name="cur_sym" required value="<?php echo e(gs('cur_sym')); ?>">
                                </div>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label class="required"> <?php echo app('translator')->get('Timezone'); ?></label>
                                <select class="select2 form-control" name="timezone">
                                    <?php $__currentLoopData = $timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e(@$key); ?>" <?php if(@$key == $currentTimezone): echo 'selected'; endif; ?>><?php echo e(__($timezone)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label cla> <?php echo app('translator')->get('Site Base Color'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker" value="<?php echo e(gs('base_color')); ?>">
                                    </span>
                                    <input type="text" class="form-control colorCode" name="base_color" value="<?php echo e(gs('base_color')); ?>" required>
                                </div>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label cla> <?php echo app('translator')->get('Site Secondary Color'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text p-0 border-0">
                                        <input type='text' class="form-control colorPicker" value="<?php echo e(gs('secondary_color')); ?>">
                                    </span>
                                    <input type="text" class="form-control colorCode" name="secondary_color" value="<?php echo e(gs('secondary_color')); ?>" required>
                                </div>
                            </div>
                            <div class="form-group col-xl-3 col-sm-6">
                                <label> <?php echo app('translator')->get('Record to Display Per page'); ?></label>
                                <select class="select2 form-control" name="paginate_number" data-minimum-results-for-search="-1" required>

                                    <?php for($i = 5; $i <= 100; $i += 5): ?>
                                        <option value="<?php echo e($i); ?>" <?php if(gs('paginate_number') == $i): echo 'selected'; endif; ?>> <?php echo e($i); ?> <?php echo app('translator')->get('items per page'); ?></option>
                                    <?php endfor; ?>
                                </select>
                            </div>

                            <div class="form-group col-xl-3 col-sm-6 ">
                                <label> <?php echo app('translator')->get('Currency Showing Format'); ?></label>
                                <select class="select2 form-control" name="currency_format" data-minimum-results-for-search="-1" required>
                                    <option value="1" <?php if(gs('currency_format') == Status::CUR_BOTH): echo 'selected'; endif; ?>><?php echo app('translator')->get('Show Currency Text and Symbol Both'); ?></option>
                                    <option value="2" <?php if(gs('currency_format') == Status::CUR_TEXT): echo 'selected'; endif; ?>><?php echo app('translator')->get('Show Currency Text Only'); ?></option>
                                    <option value="3" <?php if(gs('currency_format') == Status::CUR_SYM): echo 'selected'; endif; ?>><?php echo app('translator')->get('Show Currency Symbol Only'); ?></option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-3 col-sm-6">
                                <label><?php echo app('translator')->get('Account Number Prefix'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('This text will be added with every Account Number as a prefix.'); ?>"></i></label>
                                <input class="form-control" name="account_no_prefix" type="text" value="<?php echo e(gs()->account_no_prefix); ?>">
                            </div>

                            <div class="form-group col-md-3 col-sm-6">
                                <label><?php echo app('translator')->get('Account Number Length'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('The number of digits for an account number without the prefix.'); ?>"></i></label>
                                <input class="form-control" name="account_no_length" type="number" value="<?php echo e(gs()->account_no_length); ?>">
                            </div>

                            <div class="form-group col-md-3 col-sm-12">
                                <label><?php echo app('translator')->get('OTP Expiration Time'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('How long an OTP is valid. The Users need to verify the OTP code for any money-out transaction from this system if the OTP module is enabled.'); ?>"></i></label>
                                <div class="input-group">
                                    <input class="form-control" name="otp_time" type="number" value="<?php echo e(getAmount(gs()->otp_time)); ?>">
                                    <span class="input-group-text"> <?php echo app('translator')->get('Seconds'); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-md-3 col-sm-12">
                                <label>
                                    <?php echo app('translator')->get('User Idle Time'); ?>
                                    <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('How long a user can stay idle without any interaction. After that certain period the user will be logged out from the system'); ?>"></i>
                                </label>
                                <div class="input-group">
                                    <input class="form-control" name="idle_time_threshold" type="number" value="<?php echo e(gs()->idle_time_threshold); ?>" />
                                    <span class="input-group-text"> <?php echo app('translator')->get('Seconds'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="card-title text-center"><?php echo app('translator')->get('Transfer Limits within'); ?> <?php echo e(__(gs()->site_name)); ?></h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-sm-6 col-md-4">
                                <label>
                                    <?php echo app('translator')->get('Minimum Limit'); ?> <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('For each Money Transfer within ' . gs()->site_name . ', Users can\'t transfer money less than the Minimum Transfer Limit.'); ?>"></i>
                                </label>
                                <div class="input-group">
                                    <input class="form-control" name="minimum_transfer_limit" type="number" value="<?php echo e(getAmount(gs()->minimum_transfer_limit)); ?>" step="any">
                                    <span class="input-group-text currency-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-sm-6 col-md-4">
                                <label>
                                    <?php echo app('translator')->get('Daily Limit'); ?>
                                    <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The maximum amount that can be transferred on a particular date.'); ?>"></i>
                                </label>
                                <div class="input-group">
                                    <input class="form-control" name="daily_transfer_limit" type="number" value="<?php echo e(getAmount(gs()->daily_transfer_limit)); ?>" step="any">
                                    <span class="input-group-text currency-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>
                            <div class="form-group col-sm-12 col-md-4">
                                <label>
                                    <?php echo app('translator')->get('Monthly Limit'); ?>
                                    <i class="fas fa-info-circle text--primary" title="<?php echo app('translator')->get('The maximum amount that can be transferred on a particular month.'); ?>"></i>
                                </label>
                                <div class="input-group">
                                    <input class="form-control" name="monthly_transfer_limit" type="number" value="<?php echo e(getAmount(gs()->monthly_transfer_limit)); ?>" step="any">
                                    <span class="input-group-text currency-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h6 class="card-title text-center"><?php echo app('translator')->get('Transfer Charges within'); ?> <?php echo e(__(gs()->site_name)); ?></h6>
                    </div>

                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label><?php echo app('translator')->get('Fixed Charge'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="fixed_transfer_charge" type="number" value="<?php echo e(getAmount(gs()->fixed_transfer_charge)); ?>" step="any">
                                    <span class="input-group-text currency-text"><?php echo app('translator')->get(gs()->cur_text); ?> </span>
                                </div>
                            </div>

                            <div class="form-group col-sm-6">
                                <label><?php echo app('translator')->get('Percent Charge'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="percent_transfer_charge" type="number" value="<?php echo e(getAmount(gs()->percent_transfer_charge)); ?>" step="any">
                                    <span class="input-group-text currency-text">%</span>
                                </div>
                            </div>
                        </div>

                        <small>
                            <i class="la la-info-circle text--primary"></i>
                            <i class="text-muted"><?php echo app('translator')->get('Fixed + Percent charge amount will be applied on each transfer within'); ?> <?php echo e(__(gs()->site_name)); ?></i>
                        </small>
                    </div>
                </div>

                <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.setting.update')): ?>
                    <button class="btn btn--primary w-100 h-45 mt-3" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                <?php endif; ?>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/spectrum.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/admin/css/spectrum.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.colorPicker').spectrum({
                color: $(this).data('color'),
                change: function(color) {
                    $(this).parent().siblings('.colorCode').val(color.toHexString().replace(/^#?/, ''));
                }
            });

            $('.colorCode').on('input', function() {
                var clr = $(this).val();
                $(this).parents('.input-group').find('.colorPicker').spectrum({
                    color: clr,
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/setting/general.blade.php ENDPATH**/ ?>