<?php $__env->startPush('topBar'); ?>
    <?php echo $__env->make('admin.plans.top_bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <form action="<?php echo e(route('admin.plans.dps.save', $plan->id ?? 0)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Name'); ?></label>
                                <input class="form-control" name="name" type="text" value="<?php echo e(old('name', @$plan->name)); ?>" required>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Installment Interval'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="installment_interval" type="number" value="<?php echo e(old('installment_interval', @$plan->installment_interval)); ?>" required>
                                    <span class="input-group-text"><?php echo app('translator')->get('Days'); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Total Installment'); ?></label>
                                <input class="form-control" name="total_installment" type="number" value="<?php echo e(old('total_installment', @$plan->total_installment)); ?>" required>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Per Installment'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="per_installment" type="number" value="<?php echo e(old('per_installment', @$plan->per_installment)); ?>" step="any" required>
                                    <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Interest Rate'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="interest_rate" type="number" value="<?php echo e(old('interest_rate', @$plan->interest_rate)); ?>" step="any" required>
                                    <span class="input-group-text"><?php echo app('translator')->get('%'); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Total Deposit'); ?></label>
                                <div class="input-group">
                                    <input class="form-control total_deposit" type="text" readonly>
                                    <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('User\'s Profit'); ?></label>
                                <div class="input-group">
                                    <input class="form-control profit-amount" type="text" readonly>
                                    <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Total Mature Amount'); ?></label>
                                <div class="input-group">
                                    <input class="form-control mature-amount" type="text" readonly>
                                    <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>
                        </div>

                        <h6 class="border-bottom my-3 pb-3 text-center">
                            <?php echo app('translator')->get('Installment Delay Charge'); ?> <i class="fa fa-info-circle text--primary" title="<?php echo app('translator')->get('This charge will be apply for each delayed installment. The total amount of charge will be subtracted from the mature amount.'); ?>"></i>
                        </h6>

                        <div class="row">

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Charge will Apply If Delay'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="delay_value" type="number" value="<?php echo e(old('delay_value', @$plan->delay_value)); ?>" required>
                                    <span class="input-group-text"><?php echo app('translator')->get('Day'); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Fixed Charge'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="fixed_charge" type="number" value="<?php echo e(old('fixed_charge', @$plan->fixed_charge)); ?>" step="any" required>
                                    <span class="input-group-text"><?php echo app('translator')->get(gs()->cur_text); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Percent Charge'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="percent_charge" type="number" value="<?php echo e(old('percent_charge', @$plan->percent_charge)); ?>" step="any" required>
                                    <span class="input-group-text">%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.dps.save')): ?>
                        <div class="card-footer">
                            <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                        </div>
                    <?php endif; ?>
                </form>
            </div><!-- card end -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php if (\Illuminate\Support\Facades\Blade::check('can', 'admin.plans.dps.index')): ?>
    <?php $__env->startPush('breadcrumb-plugins'); ?>
        <?php if (isset($component)) { $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.plans.dps.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.plans.dps.index')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $attributes = $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $component = $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('[name=per_installment], [name=total_installment], [name=interest_rate]').on('input', () => calculateProfit());

            function calculateProfit() {
                let perInstallment = Number($('[name=per_installment]').val());
                let totalInstallment = Number($('[name=total_installment]').val());
                let interestRate = Number($('[name=interest_rate]').val());
                let totalAmount = perInstallment * totalInstallment;
                let interest = totalAmount * interestRate / 100;

                if (perInstallment && totalInstallment && interestRate) {
                    $('.total_deposit').val(showAmount(totalAmount));
                    $('.profit-amount').val(showAmount(interest));
                    $('.mature-amount').val(showAmount(totalAmount + interest));
                }
            };

            calculateProfit();
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/admin/plans/dps/form.blade.php ENDPATH**/ ?>