<?php
    $faq = getContent('faq.content', true);
    $faqs = getContent('faq.element', false, null, true);
    $totalEelements = $faqs->count();
?>

<?php if($faq): ?>
    <section id="faq" class="pt-100 pb-100 section--bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-5 col-lg-7 wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
                    <div class="section-header text-center">
                        <h2 class="section-title"><?php echo e(__(@$faq->data_values->heading)); ?></h2>
                        <p class="mt-2"><?php echo e(__(@$faq->data_values->subheading)); ?></p>
                    </div>
                </div>
            </div>
            <div class="accordion custom--accordion" id="faqAccordion">
                <div class="row gy-4 justify-content-center">
                    <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 wow fadeInRight <?php if($totalEelements % 2 != 0 && $loop->last): ?> col-lg-12 <?php endif; ?>" data-wow-duration="0.5s" data-wow-delay="0.3s">
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="h-<?php echo e($element->id); ?>">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-<?php echo e(@$element->id); ?>" aria-expanded="false" aria-controls="c-<?php echo e(@$element->id); ?>">
                                        <?php echo e(__(@$element->data_values->question)); ?>

                                    </button>
                                </h2>
                                <div id="c-<?php echo e($element->id); ?>" class="accordion-collapse collapse" aria-labelledby="h-<?php echo e($element->id); ?>" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        <p><?php echo e(__(@$element->data_values->answer)); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/templates/indigo_fusion/sections/faq.blade.php ENDPATH**/ ?>