<?php $__env->startSection('panel'); ?>
    <div class="row justify-content-center">
        <?php if(request()->routeIs('admin.deposit.list')): ?>
            <div class="col-12">
                <?php echo $__env->make('admin.deposit.widget', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        <?php endif; ?>
    </div>

    <?php
        $request = request();
        $tableName = 'deposits_list';
        $tableConfiguration = tableConfiguration($tableName);

        $gateways = App\Models\GatewayCurrency::orderBy('name')->get()->pluck('name')->toArray();

        $gateways[] = 'Google Pay';
        $gateways[] = 'Branch Deposit';

        sort($gateways);

        $branches = App\Models\Branch::orderBy('name')->get()->pluck('name')->toArray();

        $branches[] = 'Online';

        $branchStaff = App\Models\BranchStaff::orderBy('name')->get()->pluck('name')->toArray();


        $columns = collect([
            prepareTableColumn('trx', 'TRX No.'),
            prepareTableColumn('account_number', 'Account No.', link:'route("admin.users.detail", $item->user_id)'),
            prepareTableColumn('gateway_name', 'Gateway', filter:'select', filterOptions:$gateways),
            prepareTableColumn('branch_name', 'Branch', filter:'select', filterOptions:$branches),
            prepareTableColumn('staff_name', 'Staff', filter:'select', filterOptions:$branchStaff),
            prepareTableColumn('created_at', 'Initiated At', 'showDateTime($item->created_at)', filter: 'date'),
            prepareTableColumn('amount', 'Amount', 'showAmount($item->amount)', filter: 'range'),
            prepareTableColumn('charge', 'Charge', 'showAmount($item->charge)', filter: 'range'),
            prepareTableColumn('total_amount', 'Total', 'showAmount($item->total_amount)', filter: 'range'),
            prepareTableColumn('rate', 'Conversion Rate', 'showAmount($item->rate, currencyFormat: false) ." ". __($item->method_currency)'),
            prepareTableColumn('final_amount', 'Final Amount', 'showAmount($item->final_amount, currencyFormat: false) ." ". __($item->method_currency)'),
            prepareTableColumn('status', 'Status', '$item->status_badge', echoable:true)
        ]);

        $action = [
            'name' => 'Action',
            'style' => '',
            'show' => can('admin.deposit.details'),
            'buttons' => [
                [
                    'name' => 'Details',
                    'icon' => 'la la-desktop',
                    'link' => 'route("admin.deposit.details", $item->id)',
                    'show' => "can('admin.deposit.details')",
                    'class' => 'btn-outline--primary'
                ]
            ]
        ];

        if ($tableConfiguration) {
            $visibleColumns = $tableConfiguration->visible_columns;
        } else {
            $visibleColumns = $columns->pluck('id')->toArray();
        }
    ?>


    <?php if (isset($component)) { $__componentOriginala9d13211d16a9b68016cb700b31e0809 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala9d13211d16a9b68016cb700b31e0809 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.viser_table.table','data' => ['data' => $deposits,'columns' => $columns,'action' => $action,'columnConfig' => true,'tableName' => $tableName,'visibleColumns' => $visibleColumns,'class' => 'table-responsive--md table-responsive']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('viser_table.table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['data' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($deposits),'columns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($columns),'action' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($action),'columnConfig' => true,'tableName' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($tableName),'visibleColumns' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($visibleColumns),'class' => 'table-responsive--md table-responsive']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $attributes = $__attributesOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__attributesOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala9d13211d16a9b68016cb700b31e0809)): ?>
<?php $component = $__componentOriginala9d13211d16a9b68016cb700b31e0809; ?>
<?php unset($__componentOriginala9d13211d16a9b68016cb700b31e0809); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/rex/core/resources/views/admin/deposit/log.blade.php ENDPATH**/ ?>