<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="card custom--card mb-4 <?php if(!old('account_number')): ?> d-none <?php endif; ?>" id="addForm">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title"><span class="title"></span> <?php echo app('translator')->get(' Beneficiary to'); ?> <?php echo app('translator')->get(gs()->site_name); ?></h5>
                        <button type="button" class="btn btn-sm btn--danger close-form-btn"><i class="la la-times"></i></button>
                    </div>
                </div>

                <div class="card-body p-4">
                    <form action="<?php echo e(route('user.beneficiary.own.add')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="id">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Account Number'); ?></label>
                            <input type="text" name="account_number" value="<?php echo e(old('account_number')); ?>" class="form--control" required>
                            <small class="text--danger error-message"></small>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Account Name'); ?></label>
                            <input type="text" name="account_name" value="<?php echo e(old('account_name')); ?>" class="form--control" required>
                            <small class="text--danger error-message"></small>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Short Name'); ?></label>
                            <input type="text" name="short_name" value="<?php echo e(old('short_name')); ?>" class="form--control" required>
                        </div>

                        <button type="submit" class="btn w-100 btn--base"><?php echo app('translator')->get('Submit'); ?></button>
                    </form>
                </div>
            </div>

            <div class="table-responsive--md">
                <div class="text-end">
                    <button type="button" class="btn btn-sm btn--dark add-btn mb-3"><i class="la la-plus-circle"></i>
                        <?php echo app('translator')->get('Add Beneficiary'); ?></button>
                </div>

                <table class="table custom--table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Account Number'); ?></th>
                            <th><?php echo app('translator')->get('Account Name'); ?></th>
                            <th><?php echo app('translator')->get('Short Name'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $beneficiaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($beneficiary->account_number); ?></td>
                                <td><?php echo e($beneficiary->account_name); ?></td>
                                <td><?php echo e($beneficiary->short_name); ?></td>
                                <td>
                                    <button class="btn btn-sm btn--base editBeneficiary" data-resources="<?php echo e($beneficiary); ?>"><i class="la la-pen"></i></button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($beneficiaries->hasPages()): ?>
                <div class="mt-3">
                    <?php echo e(paginateLinks($beneficiaries)); ?>

                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            const addForm = $('#addForm');
            const editForm = $('#editForm');

            $('.add-btn').on('click', function() {
                $(this).parent().hide();
                addForm.find('.title').text(`<?php echo app('translator')->get('Add'); ?>`);
                addForm.removeClass('d-none').hide().fadeIn(500);
            });

            $('.close-form-btn').on('click', function() {
                addForm.find('form').trigger("reset");
                $('.add-btn').parent().show();
                addForm.addClass('d-none');
                $('.add-btn').removeClass('d-none').hide().fadeIn(500);
            });


            addForm.on('focusout', '[name=account_number], [name=account_name]', function() {
                let $this = $(this);
                var type = "add";
                onwBeneficiaryChecking($this, type);

            });

            editForm.on('focusout', '[name=account_number], [name=account_name]', function() {
                let $this = $(this);
                var type = "edit";
                onwBeneficiaryChecking($this, type);

            });

            function onwBeneficiaryChecking($this, type) {
                if ($this.val()) {
                    let route = `<?php echo e(route('user.beneficiary.check.account')); ?>`;
                    let data = {}
                    if (type == 'add') {
                        data.account_name = addForm.find('[name=account_name]').val();
                        data.account_number = addForm.find('[name=account_number]').val();
                    } else {
                        data.account_name = editForm.find('[name=account_name]').val();
                        data.account_number = editForm.find('[name=account_number]').val();
                        data.edit = type;
                    }

                    $.get(route, data, function(response) {
                        if (response.error) {
                            $this.parent('.form-group').find('.error-message').text(response
                                .message);
                        } else {
                            if (type == 'add') {
                                addForm.find('[name=account_number]').val(response.data.account_number);
                                addForm.find('[name=account_name]').val(response.data.account_name);
                                addForm.find('.error-message').empty();
                            } else {
                                editForm.find('[name=account_number]').val(response.data.account_number);
                                editForm.find('[name=account_name]').val(response.data.account_name);
                                editForm.find('.error-message').empty();
                            }

                        }
                    });
                } else {
                    addForm.find('.error-message').empty();
                }
            }

            $('.editBeneficiary').on('click', function() {
                addForm.removeClass('d-none').hide().fadeIn(500);

                $('.add-btn').addClass('d-none').hide().fadeIn(500);

                let beneficiary = $(this).data('resources');
                addForm.find('[name="account_number"]').val(beneficiary.account_number);
                addForm.find('[name="account_name"]').val(beneficiary.account_name);
                addForm.find('[name="short_name"]').val(beneficiary.short_name);
                addForm.find('[name="id"]').val(beneficiary.id);
                addForm.find('.title').text(`<?php echo app('translator')->get('Update'); ?>`);
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php if (isset($component)) { $__componentOriginalfaab69ae368581dbfbc77a98d132296d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalfaab69ae368581dbfbc77a98d132296d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.transfer-bottom-menu','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('transfer-bottom-menu'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalfaab69ae368581dbfbc77a98d132296d)): ?>
<?php $attributes = $__attributesOriginalfaab69ae368581dbfbc77a98d132296d; ?>
<?php unset($__attributesOriginalfaab69ae368581dbfbc77a98d132296d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalfaab69ae368581dbfbc77a98d132296d)): ?>
<?php $component = $__componentOriginalfaab69ae368581dbfbc77a98d132296d; ?>
<?php unset($__componentOriginalfaab69ae368581dbfbc77a98d132296d); ?>
<?php endif; ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aurekvig/public_html/core/resources/views/templates/indigo_fusion/user/transfer/beneficiary/own.blade.php ENDPATH**/ ?>