@extends($activeTemplate . 'layouts.master')

@php
    $user = auth()->user();
@endphp

@section('content')
<div class="container my-4">

    @if ($card && $card->status == 1)
        {{-- Approved Card View --}}
        <div class="card-wrapper mx-auto" style="max-width: 350px; perspective: 1000px;">
            <div class="card-inner" id="cardInner" style="transition: transform 0.6s; transform-style: preserve-3d; position: relative;">
                <!-- Card Front -->
                <div class="card-front bg--dark text-white rounded-3 shadow p-4" style="backface-visibility: hidden; position: absolute; width: 100%; height: 200px;">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <img src="{{ asset('assets/images/card-chip.png') }}" alt="Chip" width="40">
                        <img src="{{ asset('assets/images/visa.png') }}" alt="Visa" width="50">
                    </div>

                    <h5 class="mt-4 text-center text-white letter-spacing">
                        {{ chunk_split($card->card_number, 4, ' ') }}
                    </h5>

                    <div class="d-flex justify-content-between mt-3">
                        <small>{{ $card->card_name }}</small>
                        <small>{{ $card->expiry_date }}</small>
                    </div>

                    <div class="text-center mt-3" style="font-size: 0.9rem; opacity: 0.8;">Aurelia Capital Bank</div>
                </div>

                <!-- Card Back -->
                <div class="card-back bg--dark text-white rounded-3 shadow p-4" style="transform: rotateY(180deg); backface-visibility: hidden; position: absolute; width: 100%; height: 200px;">
                    <div class="bg-secondary" style="height: 30px;"></div>
                    <div class="mt-4">
                        <label class="small">CVV</label>
                        <div class="bg-light text-dark text-center p-2 rounded">{{ $card->cvv }}</div>
                    </div>
                    <div class="text-center mt-3" style="font-size: 0.9rem; opacity: 0.8;">Aurelia Capital Bank</div>
                </div>
            </div>
        </div>

        <div class="text-center mt-3">
            <button class="btn btn--base" onclick="flipCard()">View Back</button>
        </div>

        {{-- Card Limit Section --}}
        <div class="text-center mt-4">
            <div class="bg--dark text-white p-3 rounded shadow-sm d-inline-block">
                <strong>Card Limit:</strong> $5,000
            </div>
        </div>

    @elseif ($card && $card->status == 0)
        {{-- Pending Approval Notice --}}
        <div class="text-center text-warning mt-4">
            <p>Your virtual card is pending approval. Please check back later.</p>
        </div>

    @else
        {{-- No Card Yet --}}
        <div class="text-center text-white bg--dark">
            <p>No virtual card generated yet.</p>
            <form method="POST" action="{{ route('user.virtual.card.generate') }}">
                @csrf
                <button type="submit" class="btn btn--base">Generate Virtual Card</button>
            </form>
        </div>
    @endif
</div>

<style>
    .card-wrapper {
        height: 200px;
    }

    .card-inner.flipped {
        transform: rotateY(180deg);
    }
</style>

<script>
    let flipped = false;

    function flipCard() {
        const card = document.getElementById('cardInner');
        card.classList.toggle('flipped');
        const btn = event.target;
        flipped = !flipped;
        btn.innerText = flipped ? 'View Front' : 'View Back';
    }
</script>
@endsection