@extends($activeTemplate . 'layouts.master')

@section('content')
<div class="container mt-5">
    <div class="card custom--card">
        <div class="card-header">
            <h5 class="card-title text-center">Enter OTP & New PIN</h5>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('user.pin.reset.otp') }}">
                @csrf
                <div class="form-group">
                    <label>Enter OTP</label>
                    <input type="text" name="otp" class="form--control" required maxlength="6">
                    @error('otp') <span class="text-danger">{{ $message }}</span> @enderror
                </div>
                <div class="form-group">
                    <label>New PIN</label>
                    <input type="password" name="pin" class="form--control" required maxlength="4" minlength="4">
                </div>
                <div class="form-group">
                    <label>Confirm New PIN</label>
                    <input type="password" name="pin_confirmation" class="form--control" required maxlength="4" minlength="4">
                </div>
                <button type="submit" class="btn btn--base w-100 mt-3">Reset PIN</button>
            </form>
        </div>
    </div>
</div>
@endsection