@extends($activeTemplate . 'layouts.master')

@section('content')
<div class="pt-100 pb-100">
    <div class="d-flex justify-content-center">
        <div class="verification-code-wrapper custom--card">
            <div class="verification-area">

                {{-- OTP Instructions --}}
                @if ($verification->send_via != '2fa')
                    @include($activeTemplate . 'user.otp.email_sms')
                @endif

                @if ($verification->send_via == '2fa')
                    <p class="text-center mb-3">@lang('Get the OTP code from your Google Authenticator app')</p>
                @endif

                {{-- OTP + PIN FORM --}}
                <form action="{{ route('user.otp.submit', $verification->id) }}" method="post" class="submit-form">
                    @csrf

                    {{-- OTP FIELD --}}
                    <div class="mb-3">
                        <label for="verification-code">@lang('Enter 6-digit OTP')</label>
                        <input type="text" name="otp" id="verification-code" class="form--control text-center" maxlength="6" required autocomplete="off">
                        @error('otp')
                            <span class="text-danger d-block mt-2">{{ $message }}</span>
                        @enderror
                    </div>

                    {{-- PIN FIELD --}}
                    <div class="form-group text-center">
                        <label for="pin">@lang('Enter 4-Digit PIN')</label>
                        <input type="password" name="pin" id="pin" class="form--control pin-input text-center" maxlength="4" readonly required>
                        @error('pin')
                            <span class="text-danger d-block mt-2">{{ $message }}</span>
                        @enderror

                        {{-- On-screen PIN KEYPAD --}}
                        <div class="pin-keypad mt-3" id="pinKeypad"></div>
                        <div class="d-flex justify-content-center mt-2">
                            <button type="button" class="btn btn-sm btn-danger" onclick="clearPin()">Clear</button>
                        </div>

                        {{-- Reset PIN link --}}
                        <div class="mt-3">
                            <a href="{{ route('user.pin.reset') }}" class="text--base small">@lang('Forgot PIN? Reset it here')</a>
                        </div>
                    </div>

                    {{-- Submit --}}
                    <div class="form-group mb-0">
                        <button type="submit" class="btn btn-md btn--base w-100 mt-3">@lang('Verify')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('style')
<style>
    .pin-keypad {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 10px;
        max-width: 200px;
        margin: 0 auto;
    }
    .pin-key {
        padding: 12px;
        font-size: 18px;
        background-color: #f1f1f1;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s;
    }
    .pin-key:hover {
        background-color: #ddd;
    }
</style>
@endpush

@push('script')
<script>
    // Disable auto-submission
    document.getElementById('verification-code').addEventListener('input', function () {
        let val = this.value;
        if (val.length > 6) {
            this.value = val.slice(0, 6);
        }
    });

    // PIN KEYPAD
    const pinInput = document.getElementById('pin');
    const pinKeypad = document.getElementById('pinKeypad');

    const generateKeys = () => {
        const nums = ['1','2','3','4','5','6','7','8','9','0'];
        const shuffled = nums.sort(() => Math.random() - 0.5);
        pinKeypad.innerHTML = '';
        shuffled.forEach(num => {
            const btn = document.createElement('button');
            btn.textContent = num;
            btn.className = 'pin-key';
            btn.type = 'button';
            btn.onclick = () => {
                if (pinInput.value.length < 4) {
                    pinInput.value += num;
                    generateKeys(); // shuffle on each press
                }
            };
            pinKeypad.appendChild(btn);
        });
    };

    const clearPin = () => {
        pinInput.value = '';
        generateKeys();
    };

    document.addEventListener('DOMContentLoaded', generateKeys);
</script>
@endpush