<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ gs()->siteName($pageTitle ?? '') }}</title>
    <!-- favicon -->
    <link rel="shortcut icon" type="image/png" href="{{ siteFavicon() }}">

    <link rel="stylesheet" href="{{ asset('assets/global/css/pdf.css') }}">

    @stack('style')
</head>

<body>
    {{-- Center Watermark Stamp --}}
<div style="
    position: absolute;
    top: 40%;
    left: 50%;
    transform: translate(-50%, -50%) rotate(-15deg);
    opacity: 0.12;
    z-index: 0;
    font-size: 28px;
    font-weight: bold;
    color: #28a745;
    border: 5px dashed #28a745;
    border-radius: 50%;
    padding: 50px 100px;
    text-align: center;
    pointer-events: none;
    text-transform: uppercase;
    letter-spacing: 1px;
    white-space: nowrap;
">
    {{ strtoupper(gs()->site_name) }}<br>
    {{ now()->format('Y-m-d') }}
</div>

    <main>
        <div class="list--row">
            <div class="address-to float-left">
                <h5 class="page-title">{{ @$pageTitle }}</h5>
                @if (request()->date)
                    <p class="text-small">@lang('Date'): {{ request()->date }}</p>
                @endif

                @if (request()->search)
                    <p class="text-small">@lang('Search Key'): {{ request()->search }}</p>
                @endif
            </div>

            <div class="address-form float-right">
                <ul class="text-center">
                    <li>
                        <img src="{{ siteLogo('dark') }}" class="logo" alt="Logo">
                    </li>
                </ul>
            </div>
        </div>

        <div class="body">
            @yield('main-content')
        </div>
    </main>

    <footer>
        <div class="d-block text-center">
            @lang('Powered by') {{ __(gs()->site_name) }}
        </div>
    </footer>
</body>

</html>