@extends('admin.layouts.app')

@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10">
            <div class="card-body">
                <h5 class="card-title mb-3">{{ $pageTitle }}</h5>

                <div class="table-responsive--sm">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Card Number</th>
                                <th>Card Name</th>
                                <th>Expiry</th>
                                <th>CVV</th>
                                <th>Created</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($cards as $card)
                                <tr>
                                    <td>
                                        <span class="fw-bold">{{ @$card->user->fullname }}</span><br>
                                        <small>{{ @$card->user->email }}</small>
                                    </td>
                                    <td>{{ chunk_split(str_pad($card->card_number, 16, '0', STR_PAD_LEFT), 4, ' ') }}</td>
                                    <td>{{ $card->card_name }}</td>
                                    <td>{{ $card->expiry_date }}</td>
                                    <td>{{ $card->cvv }}</td>
                                    <td>{{ showDateTime($card->created_at) }}</td>
                                    <td>
                                        <a href="{{ route('admin.virtual.cards.approve', $card->id) }}" class="btn btn-sm btn--success">
                                            Approve
                                        </a>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="100%" class="text-center">No pending cards found</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                {{ $cards->links() }}
            </div>
        </div>
    </div>
</div>
@endsection