@extends('admin.layouts.app')

@section('panel')
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two">
                        <thead>
                            <tr>
                                <th>@lang('User')</th>
                                <th>@lang('Card Number')</th>
                                <th>@lang('Card Name')</th>
                                <th>@lang('Expiry')</th>
                                <th>@lang('CVV')</th>
                                <th>@lang('Card Type')</th>
                                <th>@lang('Created')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($cards as $card)
                                <tr>
                                    <td>
                                        <span class="fw-bold">{{ __($card->user->fullname) }}</span><br>
                                        <small>{{ __($card->user->username) }}</small>
                                    </td>
                                    <td>{{ chunk_split(str_pad($card->card_number, 16, '0', STR_PAD_LEFT), 4, ' ') }}</td>
                                    <td>{{ __($card->card_name) }}</td>
                                    <td>{{ __($card->expiry_date) }}</td>
                                    <td>{{ __($card->cvv) }}</td>
                                    <td>{{ __($card->card_type) }}</td>
                                    <td>{{ showDateTime($card->created_at) }}</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="100%" class="text-center">@lang('No approved virtual cards found')</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            @if ($cards->hasPages())
                <div class="card-footer py-4">
                    {{ paginateLinks($cards) }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection