namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use App\Models\VirtualCard;

class VirtualCardApproved extends Notification
{
    use Queueable;

    public $card;

    public function __construct(VirtualCard $card)
    {
        $this->card = $card;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Your Virtual Card is Approved')
            ->greeting('Hello ' . $notifiable->firstname . ',')
            ->line('Your virtual card has been approved and is now active.')
            ->line('Card Number: ' . chunk_split(str_pad($this->card->card_number, 16, '0', STR_PAD_LEFT), 4, ' '))
            ->line('Expiry: ' . $this->card->expiry_date)
            ->line('Thank you for using Aurelia Capital Bank!');
    }
}