<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\User;

class VirtualCard extends Model
{
    protected $table = 'virtual_cards';

    protected $fillable = [
        'user_id',
        'card_number',
        'card_name',
        'expiry_month',
        'expiry_year',
        'cvv',
        'card_type',
        'status'
    ];

    protected $casts = [
        'card_number' => 'string',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, "user_id");
    }
}