<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class CheckPin
{
    public function handle($request, Closure $next)
    {
        // Allow access to the PIN verification and setting routes
        if (
            $request->routeIs('user.verify.pin') ||
            $request->routeIs('user.verify.pin.submit') ||
            $request->routeIs('user.set.pin') ||
            $request->routeIs('user.set.pin.submit')
        ) {
            return $next($request);
        }

        // If PIN is not verified in session, redirect
        if (!session('pin_verified')) {
            return redirect()->route('user.verify.pin')->withErrors(['pin' => 'PIN required']);
        }

        return $next($request);
    }
}