<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\VirtualCard;
use Illuminate\Support\Facades\Auth;

class VirtualCardController extends Controller
{
    protected $activeTemplate;

    public function __construct()
    {
    $this->activeTemplate = activeTemplate();
    }
    public function index()
    {
    $user = Auth::user();
    $card = VirtualCard::where('user_id', $user->id)->first();
    $pageTitle = 'Virtual Card';

    return view($this->activeTemplate . 'user.virtual_card', compact('card', 'pageTitle'));
    }

    public function generate()
    {
    $user = Auth::user();

    $existingCard = VirtualCard::where('user_id', $user->id)->first();
    if ($existingCard) {
        $notify[] = ['error', 'You already have a virtual card'];
        return back()->withNotify($notify);
    }

    $card = new VirtualCard();
    $card->user_id = $user->id;
    $card->card_number = '4' . str_pad(rand(0, 999999999999999), 15, '0', STR_PAD_LEFT);
    $card->card_name = $user->firstname . ' ' . $user->lastname;

    $expiryMonth = str_pad(rand(1, 12), 2, '0', STR_PAD_LEFT);
    $expiryYear = date('y') + rand(1, 5);
    $card->expiry_date = $expiryMonth . '/' . $expiryYear;

    $card->cvv = rand(100, 999);
    $card->card_type = 'Visa';
    $card->status = 0; // ✅ This line makes sure it's pending until admin approves

    $card->save();

    $notify[] = ['success', 'Virtual Card generated and sent for approval'];
    return back()->withNotify($notify);
    }
}